/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.core.authentication;

import java.io.Serializable;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-core-authentication", automated=true)
public class HttpClientProperties
implements Serializable {
    private static final long serialVersionUID = -7494946569869245770L;
    private String connectionTimeout = "PT5S";
    private String readTimeout = "PT5S";
    private String asyncTimeout = "PT5S";
    private String hostNameVerifier = "default";
    private Truststore truststore = new Truststore();
    private boolean allowLocalLogoutUrls;

    public String getHostNameVerifier() {
        return this.hostNameVerifier;
    }

    public void setHostNameVerifier(String hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }

    public long getAsyncTimeout() {
        return Beans.newDuration(this.asyncTimeout).toMillis();
    }

    public void setAsyncTimeout(String asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public Truststore getTruststore() {
        return this.truststore;
    }

    public void setTruststore(Truststore truststore) {
        this.truststore = truststore;
    }

    public long getConnectionTimeout() {
        return Beans.newDuration(this.connectionTimeout).toMillis();
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getReadTimeout() {
        return Beans.newDuration(this.readTimeout).toMillis();
    }

    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isAllowLocalLogoutUrls() {
        return this.allowLocalLogoutUrls;
    }

    public void setAllowLocalLogoutUrls(boolean allowLocalLogoutUrls) {
        this.allowLocalLogoutUrls = allowLocalLogoutUrls;
    }

    public static class Truststore
    implements Serializable {
        private static final long serialVersionUID = -1357168622083627654L;
        private Resource file;
        private String psw = "changeit";

        public Resource getFile() {
            return this.file;
        }

        public void setFile(Resource file) {
            this.file = file;
        }

        public String getPsw() {
            return this.psw;
        }

        public void setPsw(String psw) {
            this.psw = psw;
        }
    }
}

