/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-core", automated=true)
public class CasServerProperties
implements Serializable {
    private static final long serialVersionUID = 7876382696803430817L;
    @RequiredProperty
    private String name = "https://cas.example.org:8443";
    @RequiredProperty
    private String prefix = this.name.concat("/cas");
    private Ajp ajp = new Ajp();
    private Http http = new Http();
    private HttpProxy httpProxy = new HttpProxy();
    private SslValve sslValve = new SslValve();
    private RewriteValve rewriteValve = new RewriteValve();
    private ExtendedAccessLog extAccessLog = new ExtendedAccessLog();

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this.httpProxy = httpProxy;
    }

    public ExtendedAccessLog getExtAccessLog() {
        return this.extAccessLog;
    }

    public void setExtAccessLog(ExtendedAccessLog extAccessLog) {
        this.extAccessLog = extAccessLog;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public Ajp getAjp() {
        return this.ajp;
    }

    public void setAjp(Ajp ajp) {
        this.ajp = ajp;
    }

    public SslValve getSslValve() {
        return this.sslValve;
    }

    public void setSslValve(SslValve sslValve) {
        this.sslValve = sslValve;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLoginUrl() {
        return this.getPrefix().concat("/login");
    }

    public String getLogoutUrl() {
        return this.getPrefix().concat("/logout");
    }

    public RewriteValve getRewriteValve() {
        return this.rewriteValve;
    }

    public void setRewriteValve(RewriteValve rewriteValve) {
        this.rewriteValve = rewriteValve;
    }

    public static class SslValve
    implements Serializable {
        private static final long serialVersionUID = 3164446071136700242L;
        private boolean enabled;
        private String sslClientCertHeader = "ssl_client_cert";
        private String sslCipherHeader = "ssl_cipher";
        private String sslSessionIdHeader = "ssl_session_id";
        private String sslCipherUserKeySizeHeader = "ssl_cipher_usekeysize";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getSslClientCertHeader() {
            return this.sslClientCertHeader;
        }

        public void setSslClientCertHeader(String sslClientCertHeader) {
            this.sslClientCertHeader = sslClientCertHeader;
        }

        public String getSslCipherHeader() {
            return this.sslCipherHeader;
        }

        public void setSslCipherHeader(String sslCipherHeader) {
            this.sslCipherHeader = sslCipherHeader;
        }

        public String getSslSessionIdHeader() {
            return this.sslSessionIdHeader;
        }

        public void setSslSessionIdHeader(String sslSessionIdHeader) {
            this.sslSessionIdHeader = sslSessionIdHeader;
        }

        public String getSslCipherUserKeySizeHeader() {
            return this.sslCipherUserKeySizeHeader;
        }

        public void setSslCipherUserKeySizeHeader(String sslCipherUserKeySizeHeader) {
            this.sslCipherUserKeySizeHeader = sslCipherUserKeySizeHeader;
        }
    }

    public static class RewriteValve
    implements Serializable {
        private static final long serialVersionUID = 9030094143985594411L;
        private Resource location = new ClassPathResource("container/tomcat/rewrite.config");

        public Resource getLocation() {
            return this.location;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }
    }

    public static class Http
    implements Serializable {
        private static final long serialVersionUID = -8809922027350085888L;
        private boolean enabled;
        private int port = 8080;
        private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class HttpProxy
    implements Serializable {
        private static final long serialVersionUID = 9129851352067677264L;
        private boolean enabled;
        private String scheme = "https";
        private boolean secure = true;
        private int redirectPort;
        private int proxyPort;
        private String protocol = "AJP/1.3";
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public int getRedirectPort() {
            return this.redirectPort;
        }

        public void setRedirectPort(int redirectPort) {
            this.redirectPort = redirectPort;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }
    }

    public static class ExtendedAccessLog
    implements Serializable {
        private static final long serialVersionUID = 6738161402499196038L;
        private boolean enabled;
        private String pattern = "c-ip s-ip cs-uri sc-status time x-threadname x-H(secure) x-H(remoteUser)";
        private String suffix = ".log";
        private String prefix = "localhost_access_extended";
        private String directory;

        public String getDirectory() {
            return this.directory;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static class Ajp
    implements Serializable {
        private static final long serialVersionUID = -32143821503580896L;
        private String protocol = "AJP/1.3";
        private int port = 8009;
        private boolean secure;
        private boolean allowTrace;
        private String scheme = "http";
        private boolean enabled;
        private String asyncTimeout = "PT5S";
        private boolean enableLookups;
        private int maxPostSize = 0x1400000;
        private int proxyPort = -1;
        private int redirectPort = -1;
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public boolean isAllowTrace() {
            return this.allowTrace;
        }

        public void setAllowTrace(boolean allowTrace) {
            this.allowTrace = allowTrace;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getAsyncTimeout() {
            return Beans.newDuration(this.asyncTimeout).toMillis();
        }

        public void setAsyncTimeout(String asyncTimeout) {
            this.asyncTimeout = asyncTimeout;
        }

        public boolean isEnableLookups() {
            return this.enableLookups;
        }

        public void setEnableLookups(boolean enableLookups) {
            this.enableLookups = enableLookups;
        }

        public int getMaxPostSize() {
            return this.maxPostSize;
        }

        public void setMaxPostSize(int maxPostSize) {
            this.maxPostSize = maxPostSize;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
        }

        public int getRedirectPort() {
            return this.redirectPort;
        }

        public void setRedirectPort(int redirectPort) {
            this.redirectPort = redirectPort;
        }
    }
}

