/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.javadoc.Javadoc;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.metadata.ConfigurationMetadataHint;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapSearchEntryHandlersProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.services.persondir.support.QueryType;
import org.apereo.services.persondir.util.CaseCanonicalizationMode;
import org.jooq.lambda.Unchecked;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ValueHint;
import org.springframework.core.io.Resource;
import org.springframework.util.ReflectionUtils;

public class ConfigurationMetadataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMetadataGenerator.class);
    private static final Pattern PATTERN_GENERICS = Pattern.compile(".+\\<(.+)\\>");
    private static final Pattern NESTED_TYPE_PATTERN = Pattern.compile("java\\.util\\.\\w+<(org\\.apereo\\.cas\\..+)>");
    private final String buildDir;
    private final String sourcePath;
    private final Map<String, Class> cachedPropertiesClasses = new HashMap<String, Class>();

    public ConfigurationMetadataGenerator(String buildDir, String sourcePath) {
        this.buildDir = buildDir;
        this.sourcePath = sourcePath;
    }

    public static void main(String[] args) throws Exception {
        String buildDir = args[0];
        String projectDir = args[1];
        new ConfigurationMetadataGenerator(buildDir, projectDir).execute();
    }

    public void execute() throws Exception {
        File jsonFile = new File(this.buildDir, "classes/java/main/META-INF/spring-configuration-metadata.json");
        ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TypeReference<Map<String, Set<ConfigurationMetadataProperty>>> values = new TypeReference<Map<String, Set<ConfigurationMetadataProperty>>>(){};
        Map jsonMap = (Map)mapper.readValue(jsonFile, (TypeReference)values);
        Set properties = (Set)jsonMap.get("properties");
        Set groups = (Set)jsonMap.get("groups");
        HashSet collectedProps = new HashSet();
        HashSet collectedGroups = new HashSet();
        properties.stream().filter(p -> NESTED_TYPE_PATTERN.matcher(p.getType()).matches()).forEach(Unchecked.consumer(p -> {
            Matcher matcher = NESTED_TYPE_PATTERN.matcher(p.getType());
            boolean indexBrackets = matcher.matches();
            String typeName = matcher.group(1);
            String typePath = this.buildTypeSourcePath(typeName);
            this.parseCompilationUnit(collectedProps, collectedGroups, (ConfigurationMetadataProperty)p, typePath, typeName, indexBrackets);
        }));
        properties.addAll(collectedProps);
        groups.addAll(collectedGroups);
        Set<ConfigurationMetadataHint> hints = this.processHints(properties, groups);
        jsonMap.put("properties", properties);
        jsonMap.put("groups", groups);
        jsonMap.put("hints", hints);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
        mapper.writer((PrettyPrinter)pp).writeValue(jsonFile, (Object)jsonMap);
    }

    private String buildTypeSourcePath(String type) {
        String newName = type.replace(".", File.separator);
        return this.sourcePath + "/src/main/java/" + newName + ".java";
    }

    private void parseCompilationUnit(Set<ConfigurationMetadataProperty> collectedProps, Set<ConfigurationMetadataProperty> collectedGroups, ConfigurationMetadataProperty p, String typePath, String typeName, boolean indexNameWithBrackets) {
        try (FileInputStream is = new FileInputStream(typePath);){
            CompilationUnit cu = JavaParser.parse((InputStream)is);
            new FieldVisitor(collectedProps, collectedGroups, indexNameWithBrackets, typeName).visit(cu, p);
            if (cu.getTypes().size() > 0) {
                ClassOrInterfaceDeclaration decl = (ClassOrInterfaceDeclaration)ClassOrInterfaceDeclaration.class.cast(cu.getType(0));
                for (int i = 0; i < decl.getExtendedTypes().size(); ++i) {
                    ClassOrInterfaceType parentType = (ClassOrInterfaceType)decl.getExtendedTypes().get(i);
                    Class parentClazz = this.locatePropertiesClassForType(parentType);
                    String parentTypePath = this.buildTypeSourcePath(parentClazz.getName());
                    this.parseCompilationUnit(collectedProps, collectedGroups, p, parentTypePath, parentClazz.getName(), indexNameWithBrackets);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Class locatePropertiesClassForType(ClassOrInterfaceType type) {
        if (this.cachedPropertiesClasses.containsKey(type.getNameAsString())) {
            return this.cachedPropertiesClasses.get(type.getNameAsString());
        }
        Predicate filterInputs = s -> s.contains(type.getNameAsString());
        Predicate filterResults = s -> s.endsWith(type.getNameAsString());
        String packageName = ConfigurationMetadataGenerator.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy(filterInputs).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeElementsScanner().includeFields(false).includeMethods(false).includeAnnotations(false).filterResultsBy(filterResults), new SubTypesScanner(false)}));
        Class clz = reflections.getSubTypesOf(Serializable.class).stream().filter(c -> c.getSimpleName().equalsIgnoreCase(type.getNameAsString())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cant locate class for " + type.getNameAsString()));
        this.cachedPropertiesClasses.put(type.getNameAsString(), clz);
        return clz;
    }

    private Set<ConfigurationMetadataHint> processHints(Collection<ConfigurationMetadataProperty> props, Collection<ConfigurationMetadataProperty> groups) {
        LinkedHashSet<ConfigurationMetadataHint> hints = new LinkedHashSet<ConfigurationMetadataHint>();
        for (ConfigurationMetadataProperty entry : props) {
            try {
                boolean foundRequiredProperty;
                ValueHint valueHint;
                String propName = StringUtils.substringAfterLast((String)entry.getName(), (String)".");
                String groupName = StringUtils.substringBeforeLast((String)entry.getName(), (String)".");
                ConfigurationMetadataProperty grp = groups.stream().filter(g -> g.getName().equalsIgnoreCase(groupName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cant locate group " + groupName));
                Matcher matcher = PATTERN_GENERICS.matcher(grp.getType());
                String className = matcher.find() ? matcher.group(1) : grp.getType();
                Class clazz = ClassUtils.getClass((String)className);
                ConfigurationMetadataHint hint = new ConfigurationMetadataHint();
                hint.setName(entry.getName());
                if (clazz.isAnnotationPresent(RequiresModule.class)) {
                    RequiresModule annotation = Arrays.stream(clazz.getAnnotations()).filter(a -> a.annotationType().equals(RequiresModule.class)).findFirst().map(RequiresModule.class::cast).get();
                    valueHint = new ValueHint();
                    valueHint.setValue(Stream.of(RequiresModule.class.getName(), annotation.automated()).collect(Collectors.toList()));
                    valueHint.setDescription(annotation.name());
                    hint.getValues().add(valueHint);
                }
                if (foundRequiredProperty = StreamSupport.stream(RelaxedNames.forCamelCase((String)propName).spliterator(), false).map(n -> ReflectionUtils.findField((Class)clazz, (String)n)).anyMatch(f -> f != null && f.isAnnotationPresent(RequiredProperty.class))) {
                    valueHint = new ValueHint();
                    valueHint.setValue((Object)RequiredProperty.class.getName());
                    hint.getValues().add(valueHint);
                }
                if (hint.getValues().isEmpty()) continue;
                hints.add(hint);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return hints;
    }

    private class FieldVisitor
    extends VoidVisitorAdapter<ConfigurationMetadataProperty> {
        private final Set<ConfigurationMetadataProperty> properties;
        private final Set<ConfigurationMetadataProperty> groups;
        private final String parentClass;
        private final boolean indexNameWithBrackets;

        FieldVisitor(Set<ConfigurationMetadataProperty> properties, Set<ConfigurationMetadataProperty> groups, boolean indexNameWithBrackets, String clazz) {
            this.properties = properties;
            this.groups = groups;
            this.indexNameWithBrackets = indexNameWithBrackets;
            this.parentClass = clazz;
        }

        public void visit(FieldDeclaration field, ConfigurationMetadataProperty property) {
            if (field.getVariables().isEmpty()) {
                throw new IllegalArgumentException("Field " + field + " has no variable definitions");
            }
            VariableDeclarator var = field.getVariable(0);
            if (field.getModifiers().contains(Modifier.STATIC)) {
                LOGGER.debug("Field [{}] is static and will be ignored for metadata generation", (Object)var.getNameAsString());
                return;
            }
            if (field.getJavadoc().isPresent()) {
                ConfigurationMetadataProperty prop = this.createConfigurationProperty(field, property);
                this.processNestedClassOrInterfaceTypeIfNeeded(field, prop);
            } else {
                LOGGER.error("Field " + field + " has no Javadoc defined");
            }
        }

        private ConfigurationMetadataProperty createConfigurationProperty(FieldDeclaration n, ConfigurationMetadataProperty arg) {
            VariableDeclarator variable = (VariableDeclarator)n.getVariables().get(0);
            String name = StreamSupport.stream(RelaxedNames.forCamelCase((String)variable.getNameAsString()).spliterator(), false).map(Object::toString).findFirst().orElse(variable.getNameAsString());
            String indexedGroup = arg.getName().concat(this.indexNameWithBrackets ? "[]" : "");
            String indexedName = indexedGroup.concat(".").concat(name);
            ConfigurationMetadataProperty prop = new ConfigurationMetadataProperty();
            String description = ((Javadoc)n.getJavadoc().get()).getDescription().toText();
            prop.setDescription(description);
            prop.setShortDescription(StringUtils.substringBefore((String)description, (String)"."));
            prop.setName(indexedName);
            prop.setId(indexedName);
            String elementType = n.getElementType().asString();
            if (elementType.equals(String.class.getSimpleName()) || elementType.equals(Integer.class.getSimpleName()) || elementType.equals(Long.class.getSimpleName()) || elementType.equals(Double.class.getSimpleName()) || elementType.equals(Float.class.getSimpleName())) {
                prop.setType("java.lang." + elementType);
            } else {
                prop.setType(elementType);
            }
            if (variable.getInitializer().isPresent()) {
                Expression exp = (Expression)variable.getInitializer().get();
                if (exp instanceof LiteralStringValueExpr) {
                    prop.setDefaultValue((Object)((LiteralStringValueExpr)exp).getValue());
                } else if (exp instanceof BooleanLiteralExpr) {
                    prop.setDefaultValue((Object)((BooleanLiteralExpr)exp).getValue());
                }
            }
            this.properties.add(prop);
            ConfigurationMetadataProperty grp = new ConfigurationMetadataProperty();
            grp.setId(indexedGroup);
            grp.setName(indexedGroup);
            grp.setType(this.parentClass);
            this.groups.add(grp);
            return prop;
        }

        private void processNestedClassOrInterfaceTypeIfNeeded(FieldDeclaration n, ConfigurationMetadataProperty prop) {
            Class clz;
            ClassOrInterfaceType type;
            if (n.getElementType() instanceof ClassOrInterfaceType && !this.shouldTypeBeExcluded(type = (ClassOrInterfaceType)n.getElementType()) && (clz = ConfigurationMetadataGenerator.this.locatePropertiesClassForType(type)) != null && !clz.isMemberClass()) {
                String typePath = ConfigurationMetadataGenerator.this.buildTypeSourcePath(clz.getName());
                ConfigurationMetadataGenerator.this.parseCompilationUnit(this.properties, this.groups, prop, typePath, clz.getName(), false);
            }
        }

        private boolean shouldTypeBeExcluded(ClassOrInterfaceType type) {
            return type.getNameAsString().matches(String.class.getSimpleName() + "|" + Integer.class.getSimpleName() + "|" + Double.class.getSimpleName() + "|" + Long.class.getSimpleName() + "|" + Float.class.getSimpleName() + "|" + Boolean.class.getSimpleName() + "|" + PrincipalTransformationProperties.CaseConversion.class.getSimpleName() + "|" + QueryType.class.getSimpleName() + "|" + AbstractLdapProperties.LdapType.class.getSimpleName() + "|" + CaseCanonicalizationMode.class.getSimpleName() + "|" + PasswordPolicyProperties.PasswordPolicyHandlingOptions.class.getSimpleName() + "|" + LdapSearchEntryHandlersProperties.SearchEntryHandlerTypes.class.getSimpleName() + "|" + Map.class.getSimpleName() + "|" + Resource.class.getSimpleName() + "|" + List.class.getSimpleName() + "|" + Set.class.getSimpleName());
        }
    }
}

