/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.config;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.apereo.cas.configuration.support.CasConfigurationJasyptDecryptor;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Profile(value={"standalone"})
@ConditionalOnProperty(value={"spring.cloud.config.enabled"}, havingValue="false")
@Configuration(value="casStandaloneBootstrapConfiguration")
public class CasCoreBootstrapStandaloneConfiguration
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreBootstrapStandaloneConfiguration.class);
    private CasConfigurationJasyptDecryptor configurationJasyptDecryptor;
    @Autowired
    private ResourceLoader resourceLoader;

    @ConfigurationPropertiesBinding
    @Bean
    public Converter<String, List<Class<? extends Throwable>>> commaSeparatedStringToThrowablesCollection() {
        return new Converter<String, List<Class<? extends Throwable>>>(){

            public List<Class<? extends Throwable>> convert(String source) {
                try {
                    ArrayList<Class<? extends Throwable>> classes = new ArrayList<Class<? extends Throwable>>();
                    for (String className : StringUtils.commaDelimitedListToStringArray((String)source)) {
                        classes.add(ClassUtils.forName((String)className.trim(), (ClassLoader)this.getClass().getClassLoader()));
                    }
                    return classes;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    @Bean
    public CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager() {
        return new CasConfigurationPropertiesEnvironmentManager();
    }

    public PropertySource<?> locate(Environment environment) {
        this.configurationJasyptDecryptor = new CasConfigurationJasyptDecryptor(environment);
        Properties props = new Properties();
        this.loadEmbeddedYamlOverriddenProperties(props, environment);
        File configFile = this.configurationPropertiesEnvironmentManager().getStandaloneProfileConfigurationFile();
        if (configFile != null) {
            this.loadSettingsFromStandaloneConfigFile(props, configFile);
        }
        File config = this.configurationPropertiesEnvironmentManager().getStandaloneProfileConfigurationDirectory();
        LOGGER.debug("Located CAS standalone configuration directory at [{}]", (Object)config);
        if (config.isDirectory() && config.exists()) {
            this.loadSettingsFromConfigurationSources(environment, props, config);
        } else {
            LOGGER.info("Configuration directory [{}] is not a directory or cannot be found at the specific path", (Object)config);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Located setting(s) [{}] from [{}]", props.keySet(), (Object)config);
        } else {
            LOGGER.info("Found and loaded [{}] setting(s) from [{}]", (Object)props.size(), (Object)config);
        }
        return new PropertiesPropertySource("standaloneCasConfigService", props);
    }

    private void loadSettingsFromStandaloneConfigFile(Properties props, File configFile) {
        Properties pp = new Properties();
        try (FileReader r = new FileReader(configFile);){
            LOGGER.debug("Located CAS standalone configuration file at [{}]", (Object)configFile);
            pp.load(r);
            LOGGER.debug("Found settings [{}] in file [{}]", pp.keySet(), (Object)configFile);
            props.putAll(this.decryptProperties(pp));
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> decryptProperties(Map properties) {
        return this.configurationJasyptDecryptor.decrypt(properties);
    }

    private void loadSettingsFromConfigurationSources(Environment environment, Properties props, File config) {
        List<String> profiles = this.getApplicationProfiles(environment);
        String regex = CasCoreBootstrapStandaloneConfiguration.buildPatternForConfigurationFileDiscovery(config, profiles);
        Collection<File> configFiles = CasCoreBootstrapStandaloneConfiguration.scanForConfigurationFilesByPattern(config, regex);
        LOGGER.info("Configuration files found at [{}] are [{}]", (Object)config, configFiles);
        configFiles.forEach(Unchecked.consumer(f -> {
            LOGGER.debug("Loading configuration file [{}]", f);
            if (f.getName().toLowerCase().endsWith("yml")) {
                Map pp = CasCoreBootstrapStandaloneConfiguration.loadYamlProperties(new Resource[]{new FileSystemResource(f)});
                LOGGER.debug("Found settings [{}] in YAML file [{}]", pp.keySet(), f);
                props.putAll(this.decryptProperties(pp));
            } else {
                Properties pp = new Properties();
                pp.load(new FileReader((File)f));
                LOGGER.debug("Found settings [{}] in file [{}]", pp.keySet(), f);
                props.putAll(this.decryptProperties(pp));
            }
        }));
    }

    private static Collection<File> scanForConfigurationFilesByPattern(File config, String regex) {
        return FileUtils.listFiles((File)config, (IOFileFilter)new RegexFileFilter(regex, IOCase.INSENSITIVE), (IOFileFilter)TrueFileFilter.INSTANCE).stream().sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
    }

    private static String buildPatternForConfigurationFileDiscovery(File config, List<String> profiles) {
        String propertyNames = profiles.stream().collect(Collectors.joining("|"));
        String profiledProperties = profiles.stream().map(p -> String.format("application-%s", p)).collect(Collectors.joining("|"));
        String regex = String.format("(%s|%s|application)\\.(yml|properties)", propertyNames, profiledProperties);
        LOGGER.debug("Looking for configuration files at [{}] that match the pattern [{}]", (Object)config, (Object)regex);
        return regex;
    }

    private List<String> getApplicationProfiles(Environment environment) {
        ArrayList<String> profiles = new ArrayList<String>();
        profiles.add(this.configurationPropertiesEnvironmentManager().getApplicationName());
        profiles.addAll(Arrays.stream(environment.getActiveProfiles()).collect(Collectors.toList()));
        return profiles;
    }

    private static Map loadYamlProperties(Resource ... resource) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResolutionMethod(YamlProcessor.ResolutionMethod.OVERRIDE);
        factory.setResources(resource);
        factory.setSingleton(true);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private void loadEmbeddedYamlOverriddenProperties(Properties props, Environment environment) {
        Resource resource = this.resourceLoader.getResource("classpath:/application.yml");
        if (resource != null && resource.exists()) {
            Map pp = CasCoreBootstrapStandaloneConfiguration.loadYamlProperties(resource);
            if (pp.isEmpty()) {
                LOGGER.debug("No properties were located inside [{}]", (Object)resource);
            } else {
                LOGGER.debug("Found settings [{}] in YAML file [{}]", pp.keySet(), (Object)resource);
                props.putAll(this.decryptProperties(pp));
            }
        }
    }
}

