/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration;

import java.io.File;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class CasConfigurationPropertiesEnvironmentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationPropertiesEnvironmentManager.class);
    @Autowired
    private ConfigurationPropertiesBindingPostProcessor binder;
    @Autowired
    private Environment environment;

    public File getStandaloneProfileConfigurationDirectory() {
        return (File)this.environment.getProperty("cas.standalone.config", File.class, (Object)new File("/etc/cas/config"));
    }

    public File getStandaloneProfileConfigurationFile() {
        return (File)this.environment.getProperty("cas.standalone.config.file", File.class);
    }

    public String getApplicationName() {
        return this.environment.getRequiredProperty("spring.application.name");
    }

    public void savePropertyForStandaloneProfile(Pair<String, String> pair) {
        try {
            File file = this.getStandaloneProfileConfigurationDirectory();
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)params.properties().setFile(new File(file, this.getApplicationName() + ".properties"))});
            Configuration config = (Configuration)builder.getConfiguration();
            config.setProperty((String)pair.getKey(), pair.getValue());
            builder.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void rebindCasConfigurationProperties() {
        CasConfigurationPropertiesEnvironmentManager.rebindCasConfigurationProperties(this.binder);
    }

    public static void rebindCasConfigurationProperties(ConfigurationPropertiesBindingPostProcessor binder) {
        Assert.notNull((Object)binder, (String)"Configuration binder cannot be null");
        ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
        Map map = applicationContext.getBeansOfType(CasConfigurationProperties.class);
        String name = (String)map.keySet().iterator().next();
        LOGGER.debug("Reloading CAS configuration via [{}]", (Object)name);
        Object e = applicationContext.getBean(name);
        binder.postProcessBeforeInitialization(e, name);
        Object bean = applicationContext.getAutowireCapableBeanFactory().initializeBean(e, name);
        applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        LOGGER.debug("Reloaded CAS configuration [{}]", (Object)name);
    }
}

