/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.DefaultMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.GroovyMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.RestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class MultifactorAuthenticationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultifactorAuthenticationUtils.class);

    public static MultifactorAuthenticationProviderBypass newMultifactorAuthenticationProviderBypass(MultifactorAuthenticationProviderBypassProperties props) {
        DefaultMultifactorAuthenticationProviderBypass bypass;
        switch (props.getType()) {
            case GROOVY: {
                bypass = new GroovyMultifactorAuthenticationProviderBypass(props);
                break;
            }
            case REST: {
                bypass = new RestMultifactorAuthenticationProviderBypass(props);
                break;
            }
            default: {
                bypass = new DefaultMultifactorAuthenticationProviderBypass(props);
            }
        }
        return bypass;
    }

    public static Map<String, MultifactorAuthenticationProvider> getAvailableMultifactorAuthenticationProviders(ApplicationContext applicationContext) {
        try {
            return applicationContext.getBeansOfType(MultifactorAuthenticationProvider.class, false, true);
        }
        catch (Exception e) {
            LOGGER.debug("No beans of type [{}] are available in the application context. CAS may not be configured to handle multifactor authentication requests in absence of a provider", MultifactorAuthenticationProvider.class);
            return new HashMap<String, MultifactorAuthenticationProvider>(0);
        }
    }

    public static Collection<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvidersByIds(Collection<String> ids, ApplicationContext applicationContext) {
        Map<String, MultifactorAuthenticationProvider> available = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders(applicationContext);
        Collection<MultifactorAuthenticationProvider> values = available.values();
        return values.stream().filter(p -> ids.contains(p.getId())).collect(Collectors.toSet());
    }

    @Generated
    private MultifactorAuthenticationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

