/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;

public abstract class AbstractMultifactorAuthenticationProvider
implements MultifactorAuthenticationProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMultifactorAuthenticationProvider.class);
    private static final long serialVersionUID = 4789727148134156909L;
    private MultifactorAuthenticationProviderBypass bypassEvaluator;
    private String globalFailureMode;
    private String id;
    private int order;

    public final boolean supports(Event event, Authentication authentication, RegisteredService registeredService, HttpServletRequest request) {
        if (event == null || !event.getId().matches(this.getId())) {
            LOGGER.debug("Provided event id [{}] is not applicable to this provider identified by [{}]", (Object)event, (Object)this.getId());
            return false;
        }
        if (this.bypassEvaluator != null && !this.bypassEvaluator.shouldMultifactorAuthenticationProviderExecute(authentication, registeredService, this, request)) {
            LOGGER.debug("Request cannot be supported by provider [{}] as it's configured for bypass", (Object)this.getId());
            return false;
        }
        if (this.supportsInternal(event, authentication, registeredService)) {
            LOGGER.debug("[{}] voted to support this authentication request", (Object)this.getClass().getSimpleName());
            return true;
        }
        LOGGER.debug("[{}] voted does not support this authentication request", (Object)this.getClass().getSimpleName());
        return false;
    }

    protected boolean supportsInternal(Event e, Authentication authentication, RegisteredService registeredService) {
        return true;
    }

    public boolean isAvailable(RegisteredService service) throws AuthenticationException {
        RegisteredServiceMultifactorPolicy.FailureModes failureMode = RegisteredServiceMultifactorPolicy.FailureModes.CLOSED;
        if (StringUtils.isNotBlank((CharSequence)this.globalFailureMode)) {
            failureMode = RegisteredServiceMultifactorPolicy.FailureModes.valueOf((String)this.globalFailureMode);
            LOGGER.debug("Using global multi-factor failure mode for [{}] defined as [{}]", (Object)service, (Object)failureMode);
        }
        if (service != null) {
            LOGGER.debug("Evaluating multifactor authentication policy for service [{}}", (Object)service);
            RegisteredServiceMultifactorPolicy policy = service.getMultifactorPolicy();
            if (policy != null && policy.getFailureMode() != RegisteredServiceMultifactorPolicy.FailureModes.NOT_SET) {
                failureMode = policy.getFailureMode();
                LOGGER.debug("Multi-factor failure mode for [{}] is defined as [{}]", (Object)service.getServiceId(), (Object)failureMode);
            }
        }
        if (failureMode != RegisteredServiceMultifactorPolicy.FailureModes.NONE) {
            if (this.isAvailable()) {
                return true;
            }
            String providerName = this.getClass().getSimpleName();
            if (failureMode == RegisteredServiceMultifactorPolicy.FailureModes.CLOSED) {
                LOGGER.warn("[{}] could not be reached. Authentication shall fail for [{}]", (Object)providerName, (Object)service);
                throw new AuthenticationException();
            }
            LOGGER.warn("[{}] could not be reached. Since the authentication provider is configured for the failure mode of [{}] authentication will proceed without [{}] for service [{}]", new Object[]{providerName, failureMode, providerName, service});
            return false;
        }
        LOGGER.debug("Failure mode is set to [{}]. Assuming the provider is available.", (Object)failureMode);
        return true;
    }

    protected boolean isAvailable() {
        return true;
    }

    public boolean matches(String identifier) {
        return StringUtils.isNotBlank((CharSequence)this.getId()) ? this.getId().matches(identifier) : false;
    }

    @Generated
    public String toString() {
        return "AbstractMultifactorAuthenticationProvider(bypassEvaluator=" + this.bypassEvaluator + ", globalFailureMode=" + this.globalFailureMode + ", id=" + this.id + ", order=" + this.order + ")";
    }

    @Generated
    public MultifactorAuthenticationProviderBypass getBypassEvaluator() {
        return this.bypassEvaluator;
    }

    @Generated
    public String getGlobalFailureMode() {
        return this.globalFailureMode;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setBypassEvaluator(MultifactorAuthenticationProviderBypass bypassEvaluator) {
        this.bypassEvaluator = bypassEvaluator;
    }

    @Generated
    public void setGlobalFailureMode(String globalFailureMode) {
        this.globalFailureMode = globalFailureMode;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public AbstractMultifactorAuthenticationProvider() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractMultifactorAuthenticationProvider)) {
            return false;
        }
        AbstractMultifactorAuthenticationProvider other = (AbstractMultifactorAuthenticationProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        return this.order == other.order;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractMultifactorAuthenticationProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + this.order;
        return result;
    }
}

