/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AbstractMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.VariegatedMultifactorAuthenticationProvider;
import org.springframework.util.Assert;

public class DefaultVariegatedMultifactorAuthenticationProvider
extends AbstractMultifactorAuthenticationProvider
implements VariegatedMultifactorAuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 4789727148134156909L;
    private Collection<MultifactorAuthenticationProvider> providers = new HashSet<MultifactorAuthenticationProvider>();

    public DefaultVariegatedMultifactorAuthenticationProvider() {
    }

    public DefaultVariegatedMultifactorAuthenticationProvider(Collection<MultifactorAuthenticationProvider> providers) {
        this.providers = providers;
    }

    public void addProvider(MultifactorAuthenticationProvider provider) {
        this.providers.add(provider);
    }

    public Collection<MultifactorAuthenticationProvider> getProviders() {
        return this.providers;
    }

    @Override
    public boolean isAvailable(RegisteredService service) throws AuthenticationException {
        long count = this.providers.stream().filter(p -> p.isAvailable(service)).count();
        return count == (long)this.providers.size();
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public String getId() {
        return this.providers.stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.joining("|"));
    }

    @Override
    public boolean matches(String identifier) {
        return this.findProvider(identifier) != null;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public MultifactorAuthenticationProvider findProvider(String identifier) {
        return this.providers.stream().filter(p -> p.matches(identifier)).findFirst().orElse(null);
    }

    public <T extends MultifactorAuthenticationProvider> T findProvider(String identifier, Class<T> clazz) {
        Assert.notNull(clazz, (String)"clazz cannot be null");
        MultifactorAuthenticationProvider provider = this.findProvider(identifier);
        if (provider == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(provider.getClass())) {
            throw new ClassCastException("MultifactorAuthenticationProvider [" + provider.getId() + " is of type " + provider.getClass() + " when we were expecting " + clazz);
        }
        return (T)provider;
    }

    public String getFriendlyName() {
        return this.providers.stream().map(MultifactorAuthenticationProvider::getFriendlyName).collect(Collectors.joining("|"));
    }
}

