/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnMappedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnMappedAttributeReleasePolicy.class);
    private static final long serialVersionUID = -6249488544306639050L;
    private Map<String, Object> allowedAttributes = new TreeMap<String, Object>();

    public Map<String, Object> getAllowedAttributes() {
        return new TreeMap<String, Object>(this.allowedAttributes);
    }

    @Override
    public Map<String, Object> getAttributesInternal(Principal principal, Map<String, Object> attrs, RegisteredService service) {
        TreeMap<String, Object> resolvedAttributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attrs);
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        this.allowedAttributes.entrySet().forEach(entry -> {
            String attributeName = (String)entry.getKey();
            List mappedAttributes = CollectionUtils.wrap(entry.getValue());
            LOGGER.debug("Attempting to map allowed attribute name [{}]", (Object)attributeName);
            Object attributeValue = resolvedAttributes.get(attributeName);
            mappedAttributes.forEach(mapped -> {
                String mappedAttributeName = mapped.toString();
                LOGGER.debug("Mapping attribute [{}] to [{}] with value [{}]", new Object[]{attributeName, mappedAttributeName, attributeValue});
                ReturnMappedAttributeReleasePolicy.mapSingleAttributeDefinition(attributeName, mappedAttributeName, attributeValue, resolvedAttributes, attributesToRelease);
            });
        });
        return attributesToRelease;
    }

    private static void mapSingleAttributeDefinition(String attributeName, String mappedAttributeName, Object attributeValue, Map<String, Object> resolvedAttributes, Map<String, Object> attributesToRelease) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)mappedAttributeName);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)mappedAttributeName);
        if (matcherInline.find()) {
            LOGGER.debug("Mapped attribute [{}] is an inlined groovy script", (Object)mappedAttributeName);
            ReturnMappedAttributeReleasePolicy.processInlineGroovyAttribute(resolvedAttributes, attributesToRelease, matcherInline, attributeName);
        } else if (matcherFile.find()) {
            LOGGER.debug("Mapped attribute [{}] is an external groovy script", (Object)mappedAttributeName);
            ReturnMappedAttributeReleasePolicy.processFileBasedGroovyAttributes(resolvedAttributes, attributesToRelease, matcherFile, attributeName);
        } else if (attributeValue != null) {
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes, mapped to the name [{}]", (Object)attributeName, (Object)mappedAttributeName);
            attributesToRelease.put(mappedAttributeName, attributeValue);
        } else {
            LOGGER.warn("Could not find value for mapped attribute [{}] that is based off of [{}] in the allowed attributes list. Ensure the original attribute [{}] is retrieved and contains at least a single value. Attribute [{}] will and can not be released without the presence of a value.", new Object[]{mappedAttributeName, attributeName, attributeName, mappedAttributeName});
        }
    }

    private static void processFileBasedGroovyAttributes(Map<String, Object> resolvedAttributes, Map<String, Object> attributesToRelease, Matcher matcherFile, String key) {
        try {
            LOGGER.debug("Found groovy script to execute for attribute mapping [{}]", (Object)key);
            File file = new File(matcherFile.group(2));
            String script = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            Object result = ReturnMappedAttributeReleasePolicy.getGroovyAttributeValue(script, resolvedAttributes);
            if (result != null) {
                LOGGER.debug("Mapped attribute [{}] to [{}] from script", (Object)key, result);
                attributesToRelease.put(key, result);
            } else {
                LOGGER.warn("Groovy-scripted attribute returned no value for [{}]", (Object)key);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void processInlineGroovyAttribute(Map<String, Object> resolvedAttributes, Map<String, Object> attributesToRelease, Matcher matcherInline, String attributeName) {
        LOGGER.debug("Found inline groovy script to execute for attribute mapping [{}]", (Object)attributeName);
        Object result = ReturnMappedAttributeReleasePolicy.getGroovyAttributeValue(matcherInline.group(1), resolvedAttributes);
        if (result != null) {
            LOGGER.debug("Mapped attribute [{}] to [{}] from script", (Object)attributeName, result);
            attributesToRelease.put(attributeName, result);
        } else {
            LOGGER.warn("Groovy-scripted attribute returned no value for [{}]", (Object)attributeName);
        }
    }

    private static Object getGroovyAttributeValue(String groovyScript, Map<String, Object> resolvedAttributes) {
        Map args = CollectionUtils.wrap((String)"attributes", resolvedAttributes, (String)"logger", (Object)LOGGER);
        return ScriptingUtils.executeGroovyShellScript((String)groovyScript, (Map)args, Object.class);
    }

    @Override
    @Generated
    public String toString() {
        return "ReturnMappedAttributeReleasePolicy(super=" + super.toString() + ", allowedAttributes=" + this.allowedAttributes + ")";
    }

    @Generated
    public void setAllowedAttributes(Map<String, Object> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnMappedAttributeReleasePolicy)) {
            return false;
        }
        ReturnMappedAttributeReleasePolicy other = (ReturnMappedAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$allowedAttributes = this.allowedAttributes;
        Map<String, Object> other$allowedAttributes = other.allowedAttributes;
        return !(this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnMappedAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        return result;
    }

    @Generated
    public ReturnMappedAttributeReleasePolicy(Map<String, Object> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Generated
    public ReturnMappedAttributeReleasePolicy() {
    }
}

