/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenyAllAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    private static final long serialVersionUID = -6215588543966639050L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DenyAllAttributeReleasePolicy.class);

    public DenyAllAttributeReleasePolicy() {
        this.setExcludeDefaultAttributes(true);
        this.setPrincipalIdAttribute(null);
        this.setAuthorizedToReleaseAuthenticationAttributes(false);
        this.setAuthorizedToReleaseCredentialPassword(false);
        this.setAuthorizedToReleaseProxyGrantingTicket(false);
    }

    @Override
    protected Map<String, Object> getAttributesInternal(Principal principal, Map<String, Object> attributes, RegisteredService service) {
        LOGGER.debug("Ignoring all attributes given the service is designed to never receive any.");
        return new HashMap<String, Object>(0);
    }

    @Override
    public boolean isExcludeDefaultAttributes() {
        return true;
    }

    @Override
    public String getPrincipalIdAttribute() {
        return null;
    }

    @Override
    public boolean isAuthorizedToReleaseCredentialPassword() {
        LOGGER.debug("CAS will not authorize the release of credential password, given the service is denied access to all attributes.");
        return false;
    }

    @Override
    public boolean isAuthorizedToReleaseProxyGrantingTicket() {
        LOGGER.debug("CAS will not authorize the release of proxy-granting tickets, given the service is denied access to all attributes.");
        return false;
    }

    @Override
    public boolean isAuthorizedToReleaseAuthenticationAttributes() {
        LOGGER.debug("CAS will not authorize the release of authentication attributes, given the service is denied access to all attributes.");
        return false;
    }

    @Override
    protected Map<String, Object> returnFinalAttributesCollection(Map<String, Object> attributesToRelease, RegisteredService service) {
        LOGGER.info("CAS will not authorize anything for release, given the service is denied access to all attributes. If there are any default attributes set to be released to all services, those are also skipped for [{}]", (Object)service);
        return new HashMap<String, Object>(0);
    }
}

