/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.PostLoad;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRegisteredServiceAttributeReleasePolicy
implements RegisteredServiceAttributeReleasePolicy,
Serializable {
    private static final long serialVersionUID = 5325460875620586503L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegisteredServiceAttributeReleasePolicy.class);
    private RegisteredServiceAttributeFilter registeredServiceAttributeFilter;
    private PrincipalAttributesRepository principalAttributesRepository = new DefaultPrincipalAttributesRepository();
    private RegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy();
    private boolean authorizedToReleaseCredentialPassword;
    private boolean authorizedToReleaseProxyGrantingTicket;
    private boolean excludeDefaultAttributes;
    private boolean authorizedToReleaseAuthenticationAttributes = true;
    private String principalIdAttribute;

    @PostLoad
    public void postLoad() {
        if (this.principalAttributesRepository == null) {
            this.principalAttributesRepository = new DefaultPrincipalAttributesRepository();
        }
        if (this.consentPolicy == null) {
            this.consentPolicy = new DefaultRegisteredServiceConsentPolicy();
        }
    }

    public void setAttributeFilter(RegisteredServiceAttributeFilter filter) {
        this.registeredServiceAttributeFilter = filter;
    }

    public void setPrincipalAttributesRepository(PrincipalAttributesRepository repository) {
        this.principalAttributesRepository = repository;
    }

    public PrincipalAttributesRepository getPrincipalAttributesRepository() {
        return this.principalAttributesRepository;
    }

    public RegisteredServiceAttributeFilter getAttributeFilter() {
        return this.registeredServiceAttributeFilter;
    }

    public String getPrincipalIdAttribute() {
        return this.principalIdAttribute;
    }

    public void setPrincipalIdAttribute(String principalIdAttribute) {
        this.principalIdAttribute = principalIdAttribute;
    }

    public RegisteredServiceConsentPolicy getConsentPolicy() {
        return this.consentPolicy;
    }

    public void setConsentPolicy(RegisteredServiceConsentPolicy consentPolicy) {
        this.consentPolicy = consentPolicy;
    }

    public boolean isAuthorizedToReleaseCredentialPassword() {
        return this.authorizedToReleaseCredentialPassword;
    }

    public boolean isAuthorizedToReleaseProxyGrantingTicket() {
        return this.authorizedToReleaseProxyGrantingTicket;
    }

    public void setAuthorizedToReleaseCredentialPassword(boolean authorizedToReleaseCredentialPassword) {
        this.authorizedToReleaseCredentialPassword = authorizedToReleaseCredentialPassword;
    }

    public void setAuthorizedToReleaseProxyGrantingTicket(boolean authorizedToReleaseProxyGrantingTicket) {
        this.authorizedToReleaseProxyGrantingTicket = authorizedToReleaseProxyGrantingTicket;
    }

    public boolean isExcludeDefaultAttributes() {
        return this.excludeDefaultAttributes;
    }

    public void setExcludeDefaultAttributes(boolean excludeDefaultAttributes) {
        this.excludeDefaultAttributes = excludeDefaultAttributes;
    }

    public boolean isAuthorizedToReleaseAuthenticationAttributes() {
        return this.authorizedToReleaseAuthenticationAttributes;
    }

    public void setAuthorizedToReleaseAuthenticationAttributes(boolean authorizedToReleaseAuthenticationAttributes) {
        this.authorizedToReleaseAuthenticationAttributes = authorizedToReleaseAuthenticationAttributes;
    }

    public Map<String, Object> getConsentableAttributes(Principal p, Service selectedService, RegisteredService service) {
        if (this.consentPolicy != null && !this.consentPolicy.isEnabled()) {
            LOGGER.debug("Consent is disabled for service [{}]", (Object)service);
            return new LinkedHashMap<String, Object>(0);
        }
        Map<String, Object> attributes = this.getAttributes(p, selectedService, service);
        LOGGER.debug("Initial set of consentable attributes are [{}]", attributes);
        if (this.consentPolicy != null) {
            LOGGER.debug("Activating consent policy [{}] for service [{}]", (Object)this.consentPolicy, (Object)service);
            if (this.consentPolicy.getExcludedAttributes() != null && !this.consentPolicy.getExcludedAttributes().isEmpty()) {
                this.consentPolicy.getExcludedAttributes().forEach(attributes::remove);
                LOGGER.debug("Consentable attributes after removing excluded attributes are [{}]", attributes);
            } else {
                LOGGER.debug("No attributes are defined per the consent policy to be excluded from the consentable attributes");
            }
            if (this.consentPolicy.getIncludeOnlyAttributes() != null && !this.consentPolicy.getIncludeOnlyAttributes().isEmpty()) {
                attributes.keySet().retainAll(this.consentPolicy.getIncludeOnlyAttributes());
                LOGGER.debug("Consentable attributes after force-including attributes are [{}]", attributes);
            } else {
                LOGGER.debug("No attributes are defined per the consent policy to forcefully be included in the consentable attributes");
            }
        } else {
            LOGGER.debug("No consent policy is defined for service [{}]. Using the collection of attributes released for consent", (Object)service);
        }
        LOGGER.debug("Finalized set of consentable attributes are [{}]", attributes);
        return attributes;
    }

    public Map<String, Object> getAttributes(Principal principal, Service selectedService, RegisteredService registeredService) {
        LOGGER.debug("Initiating attributes release phase for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{principal.getId(), selectedService.getId(), registeredService.getServiceId()});
        LOGGER.debug("Locating principal attributes for [{}]", (Object)principal.getId());
        Map principalAttributes = this.getPrincipalAttributesRepository() == null ? principal.getAttributes() : this.getPrincipalAttributesRepository().getAttributes(principal);
        LOGGER.debug("Found principal attributes [{}] for [{}]", (Object)principalAttributes, (Object)principal.getId());
        LOGGER.debug("Calling attribute policy [{}] to process attributes for [{}]", (Object)this.getClass().getSimpleName(), (Object)principal.getId());
        Map<String, Object> policyAttributes = this.getAttributesInternal(principal, principalAttributes, registeredService);
        LOGGER.debug("Attribute policy [{}] allows release of [{}] for [{}]", new Object[]{this.getClass().getSimpleName(), policyAttributes, principal.getId()});
        LOGGER.debug("Attempting to merge policy attributes and default attributes");
        TreeMap<String, Object> attributesToRelease = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (this.isExcludeDefaultAttributes()) {
            LOGGER.debug("Ignoring default attribute policy attributes");
        } else {
            LOGGER.debug("Checking default attribute policy attributes");
            Map<String, Object> defaultAttributes = this.getReleasedByDefaultAttributes(principal, principalAttributes);
            LOGGER.debug("Default attributes found to be released are [{}]", defaultAttributes);
            LOGGER.debug("Adding default attributes first to the released set of attributes");
            attributesToRelease.putAll(defaultAttributes);
        }
        LOGGER.debug("Adding policy attributes to the released set of attributes");
        attributesToRelease.putAll(policyAttributes);
        this.insertPrincipalIdAsAttributeIfNeeded(principal, attributesToRelease, selectedService, registeredService);
        if (this.getAttributeFilter() != null) {
            LOGGER.debug("Invoking attribute filter [{}] on the final set of attributes", (Object)this.getAttributeFilter());
            return this.getAttributeFilter().filter(attributesToRelease);
        }
        LOGGER.debug("Finalizing attributes release phase for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{principal.getId(), selectedService.getId(), registeredService.getServiceId()});
        return this.returnFinalAttributesCollection(attributesToRelease, registeredService);
    }

    protected void insertPrincipalIdAsAttributeIfNeeded(Principal principal, Map<String, Object> attributesToRelease, Service service, RegisteredService registeredService) {
        if (StringUtils.isNotBlank((CharSequence)this.getPrincipalIdAttribute())) {
            LOGGER.debug("Attempting to resolve the principal id for service [{}]", (Object)registeredService.getServiceId());
            String id = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service, registeredService);
            LOGGER.debug("Releasing resolved principal id [{}] as attribute [{}]", (Object)id, (Object)this.getPrincipalIdAttribute());
            attributesToRelease.put(this.getPrincipalIdAttribute(), principal.getId());
        }
    }

    protected Map<String, Object> returnFinalAttributesCollection(Map<String, Object> attributesToRelease, RegisteredService service) {
        LOGGER.debug("Final collection of attributes allowed are: [{}]", attributesToRelease);
        return attributesToRelease;
    }

    protected Map<String, Object> getReleasedByDefaultAttributes(Principal p, Map<String, Object> attributes) {
        ApplicationContext ctx = ApplicationContextProvider.getApplicationContext();
        if (ctx != null) {
            LOGGER.debug("Located application context. Retrieving default attributes for release, if any");
            CasConfigurationProperties props = (CasConfigurationProperties)ctx.getAutowireCapableBeanFactory().getBean(CasConfigurationProperties.class);
            Set defaultAttrs = props.getAuthn().getAttributeRepository().getDefaultAttributesToRelease();
            LOGGER.debug("Default attributes for release are: [{}]", (Object)defaultAttrs);
            TreeMap<String, Object> defaultAttributesToRelease = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            defaultAttrs.stream().forEach(key -> {
                if (attributes.containsKey(key)) {
                    LOGGER.debug("Found and added default attribute for release: [{}]", key);
                    defaultAttributesToRelease.put((String)key, attributes.get(key));
                }
            });
            return defaultAttributesToRelease;
        }
        return new TreeMap<String, Object>();
    }

    protected abstract Map<String, Object> getAttributesInternal(Principal var1, Map<String, Object> var2, RegisteredService var3);

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.getAttributeFilter()).append(this.isAuthorizedToReleaseCredentialPassword()).append(this.isAuthorizedToReleaseProxyGrantingTicket()).append((Object)this.getPrincipalAttributesRepository()).append(this.isExcludeDefaultAttributes()).append((Object)this.getPrincipalIdAttribute()).append((Object)this.getConsentPolicy()).append(this.isAuthorizedToReleaseAuthenticationAttributes()).toHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredServiceAttributeReleasePolicy)) {
            return false;
        }
        AbstractRegisteredServiceAttributeReleasePolicy that = (AbstractRegisteredServiceAttributeReleasePolicy)o;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.getAttributeFilter(), (Object)that.getAttributeFilter()).append(this.isAuthorizedToReleaseCredentialPassword(), that.isAuthorizedToReleaseCredentialPassword()).append(this.isAuthorizedToReleaseProxyGrantingTicket(), that.isAuthorizedToReleaseProxyGrantingTicket()).append((Object)this.getPrincipalAttributesRepository(), (Object)that.getPrincipalAttributesRepository()).append(this.isExcludeDefaultAttributes(), that.isExcludeDefaultAttributes()).append((Object)this.getPrincipalIdAttribute(), (Object)that.getPrincipalIdAttribute()).append((Object)this.getConsentPolicy(), (Object)that.getConsentPolicy()).append(this.isAuthorizedToReleaseAuthenticationAttributes(), that.isAuthorizedToReleaseAuthenticationAttributes()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("attributeFilter", (Object)this.getAttributeFilter()).append("principalAttributesRepository", (Object)this.getPrincipalAttributesRepository()).append("authorizedToReleaseCredentialPassword", this.isAuthorizedToReleaseCredentialPassword()).append("authorizedToReleaseAuthenticationAttributes", this.isAuthorizedToReleaseAuthenticationAttributes()).append("authorizedToReleaseProxyGrantingTicket", this.isAuthorizedToReleaseProxyGrantingTicket()).append("excludeDefaultAttributes", this.isExcludeDefaultAttributes()).append("principalIdAttribute", (Object)this.getPrincipalIdAttribute()).append("consentPolicy", (Object)this.getConsentPolicy()).toString();
    }
}

