/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.cache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.cache.AbstractPrincipalAttributesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

public class CachingPrincipalAttributesRepository
extends AbstractPrincipalAttributesRepository {
    private static final long serialVersionUID = 6350244643948535906L;
    private static final long DEFAULT_MAXIMUM_CACHE_SIZE = 1000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingPrincipalAttributesRepository.class);
    @JsonIgnore
    @Transient
    private final transient Cache<String, Map<String, Object>> cache;
    @JsonIgnore
    @Transient
    private final transient PrincipalAttributesCacheLoader cacheLoader = new PrincipalAttributesCacheLoader();
    private long maxCacheSize = 1000L;

    private CachingPrincipalAttributesRepository() {
        this.cache = Caffeine.newBuilder().maximumSize(this.maxCacheSize).expireAfterWrite(this.getExpiration(), TimeUnit.valueOf(this.getTimeUnit())).build((CacheLoader)this.cacheLoader);
    }

    public CachingPrincipalAttributesRepository(String timeUnit, long expiryDuration) {
        this(1000L, timeUnit, expiryDuration);
    }

    public CachingPrincipalAttributesRepository(long maxCacheSize, String timeUnit, long expiryDuration) {
        super(expiryDuration, timeUnit);
        this.maxCacheSize = maxCacheSize;
        this.cache = Caffeine.newBuilder().maximumSize(maxCacheSize).expireAfterWrite(this.getExpiration(), TimeUnit.valueOf(this.getTimeUnit())).build((CacheLoader)this.cacheLoader);
    }

    @Override
    protected void addPrincipalAttributes(String id, Map<String, Object> attributes) {
        this.cache.put((Object)id, attributes);
        LOGGER.debug("Cached attributes for [{}]", (Object)id);
    }

    @Override
    protected Map<String, Object> getPrincipalAttributes(Principal p) {
        try {
            return (Map)this.cache.get((Object)p.getId(), s -> {
                LOGGER.debug("No cached attributes could be found for [{}]", (Object)p.getId());
                return new TreeMap(String.CASE_INSENSITIVE_ORDER);
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new HashMap<String, Object>(0);
        }
    }

    @Override
    public void close() {
        this.cache.cleanUp();
    }

    private static class PrincipalAttributesCacheLoader
    implements CacheLoader<String, Map<String, Object>> {
        private PrincipalAttributesCacheLoader() {
        }

        public Map<String, Object> load(String key) {
            return new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
    }
}

