/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributes;
import org.apereo.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonDirectoryPrincipalResolver.class);
    protected final IPersonAttributeDao attributeRepository;
    protected final PrincipalFactory principalFactory;
    protected final boolean returnNullIfNoAttributes;
    protected final PrincipalNameTransformer principalNameTransformer;
    protected final String principalAttributeName;

    public PersonDirectoryPrincipalResolver() {
        this((IPersonAttributeDao)new StubPersonAttributeDao(new HashMap()), PrincipalFactoryUtils.newPrincipalFactory(), false, String::trim, null);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, String principalAttributeName) {
        this(attributeRepository, PrincipalFactoryUtils.newPrincipalFactory(), false, formUserId -> formUserId, principalAttributeName);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository) {
        this(attributeRepository, PrincipalFactoryUtils.newPrincipalFactory(), false, formUserId -> formUserId, null);
    }

    public PersonDirectoryPrincipalResolver(boolean returnNullIfNoAttributes, String principalAttributeName) {
        this((IPersonAttributeDao)new StubPersonAttributeDao(new HashMap()), PrincipalFactoryUtils.newPrincipalFactory(), returnNullIfNoAttributes, String::trim, principalAttributeName);
    }

    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, PrincipalFactory principalFactory, boolean returnNullIfNoAttributes, String principalAttributeName) {
        this(attributeRepository, principalFactory, returnNullIfNoAttributes, formUserId -> formUserId, principalAttributeName);
    }

    public boolean supports(Credential credential) {
        return credential != null && credential.getId() != null;
    }

    public Principal resolve(Credential credential, Optional<Principal> currentPrincipal, Optional<AuthenticationHandler> handler) {
        LOGGER.debug("Attempting to resolve a principal...");
        String principalId = this.extractPrincipalId(credential, currentPrincipal);
        if (StringUtils.isBlank((CharSequence)principalId)) {
            LOGGER.debug("Principal id [{}] could not be found", (Object)principalId);
            return null;
        }
        if (this.principalNameTransformer != null) {
            principalId = this.principalNameTransformer.transform(principalId);
        }
        if (StringUtils.isBlank((CharSequence)principalId)) {
            LOGGER.debug("Principal id [{}] could not be found", (Object)principalId);
            return null;
        }
        LOGGER.debug("Creating principal for [{}]", (Object)principalId);
        Map<String, List<Object>> attributes = this.retrievePersonAttributes(principalId, credential);
        if (attributes == null || attributes.isEmpty()) {
            LOGGER.debug("Principal id [{}] did not specify any attributes", (Object)principalId);
            if (!this.returnNullIfNoAttributes) {
                LOGGER.debug("Returning the principal with id [{}] without any attributes", (Object)principalId);
                return this.principalFactory.createPrincipal(principalId);
            }
            LOGGER.debug("[{}] is configured to return null if no attributes are found for [{}]", (Object)this.getClass().getName(), (Object)principalId);
            return null;
        }
        LOGGER.debug("Retrieved [{}] attribute(s) from the repository", (Object)attributes.size());
        Pair<String, Map<String, Object>> pair = this.convertPersonAttributesToPrincipal(principalId, attributes);
        return this.principalFactory.createPrincipal((String)pair.getKey(), (Map)pair.getValue());
    }

    protected Pair<String, Map<String, Object>> convertPersonAttributesToPrincipal(String extractedPrincipalId, Map<String, List<Object>> attributes) {
        String[] principalId = new String[]{extractedPrincipalId};
        HashMap convertedAttributes = new HashMap();
        attributes.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            LOGGER.debug("Found attribute [{}]", (Object)key);
            List values = (List)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)this.principalAttributeName) && key.equalsIgnoreCase(this.principalAttributeName)) {
                if (values.isEmpty()) {
                    LOGGER.debug("[{}] is empty, using [{}] for principal", (Object)this.principalAttributeName, (Object)extractedPrincipalId);
                } else {
                    principalId[0] = values.get(0).toString();
                    LOGGER.debug("Found principal attribute value [{}]; removing [{}] from attribute map.", (Object)extractedPrincipalId, (Object)this.principalAttributeName);
                }
            } else {
                convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
            }
        });
        return Pair.of((Object)principalId[0], convertedAttributes);
    }

    protected Map<String, List<Object>> retrievePersonAttributes(String principalId, Credential credential) {
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        return attributes;
    }

    protected String extractPrincipalId(Credential credential, Optional<Principal> currentPrincipal) {
        return credential.getId();
    }

    @Generated
    public String toString() {
        return "PersonDirectoryPrincipalResolver(attributeRepository=" + this.attributeRepository + ", principalFactory=" + this.principalFactory + ", returnNullIfNoAttributes=" + this.returnNullIfNoAttributes + ", principalNameTransformer=" + this.principalNameTransformer + ", principalAttributeName=" + this.principalAttributeName + ")";
    }

    @Generated
    public PersonDirectoryPrincipalResolver(IPersonAttributeDao attributeRepository, PrincipalFactory principalFactory, boolean returnNullIfNoAttributes, PrincipalNameTransformer principalNameTransformer, String principalAttributeName) {
        this.attributeRepository = attributeRepository;
        this.principalFactory = principalFactory;
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
        this.principalNameTransformer = principalNameTransformer;
        this.principalAttributeName = principalAttributeName;
    }

    @Generated
    public IPersonAttributeDao getAttributeRepository() {
        return this.attributeRepository;
    }

    @Generated
    public PrincipalFactory getPrincipalFactory() {
        return this.principalFactory;
    }

    @Generated
    public boolean isReturnNullIfNoAttributes() {
        return this.returnNullIfNoAttributes;
    }

    @Generated
    public PrincipalNameTransformer getPrincipalNameTransformer() {
        return this.principalNameTransformer;
    }

    @Generated
    public String getPrincipalAttributeName() {
        return this.principalAttributeName;
    }
}

