/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.security.GeneralSecurityException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniquePrincipalAuthenticationPolicy
implements AuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UniquePrincipalAuthenticationPolicy.class);
    private final TicketRegistry ticketRegistry;

    public boolean isSatisfiedBy(Authentication authentication) throws Exception {
        try {
            Principal authPrincipal = authentication.getPrincipal();
            long count = this.ticketRegistry.getTickets(t -> {
                boolean pass;
                boolean bl = pass = TicketGrantingTicket.class.isInstance(t) && !t.isExpired();
                if (pass) {
                    Principal principal = ((TicketGrantingTicket)TicketGrantingTicket.class.cast(t)).getAuthentication().getPrincipal();
                    pass = principal.getId().equalsIgnoreCase(authPrincipal.getId());
                }
                return pass;
            }).count();
            if (count == 0L) {
                LOGGER.debug("Authentication policy is satisfied with [{}]", (Object)authPrincipal.getId());
                return true;
            }
            LOGGER.warn("Authentication policy cannot be satisfied for principal [{}] because [{}] sessions currently exist", (Object)authPrincipal.getId(), (Object)count);
            return false;
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Generated
    public UniquePrincipalAuthenticationPolicy(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

