/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.RememberMeCredential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RememberMeAuthenticationMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RememberMeAuthenticationMetaDataPopulator.class);

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        transaction.getPrimaryCredential().ifPresent(r -> {
            if (((RememberMeCredential)RememberMeCredential.class.cast(r)).isRememberMe()) {
                LOGGER.debug("Credential is configured to be remembered. Captured this as [{}] attribute", (Object)"org.apereo.cas.authentication.principal.REMEMBER_ME");
                builder.addAttribute("org.apereo.cas.authentication.principal.REMEMBER_ME", (Object)Boolean.TRUE);
            }
        });
    }

    public boolean supports(Credential credential) {
        return credential instanceof RememberMeCredential;
    }

    @Override
    @Generated
    public String toString() {
        return "RememberMeAuthenticationMetaDataPopulator(super=" + super.toString() + ")";
    }
}

