/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.PrePostAuthenticationHandler;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreAndPostProcessingAuthenticationHandler
extends AbstractAuthenticationHandler
implements PrePostAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPreAndPostProcessingAuthenticationHandler.class);

    public AbstractPreAndPostProcessingAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    public AuthenticationHandlerExecutionResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        if (!this.preAuthenticate(credential)) {
            throw new FailedLoginException();
        }
        return this.postAuthenticate(credential, this.doAuthentication(credential));
    }

    protected abstract AuthenticationHandlerExecutionResult doAuthentication(Credential var1) throws GeneralSecurityException, PreventedException;

    protected AuthenticationHandlerExecutionResult createHandlerResult(@NonNull Credential credential, @NonNull Principal principal, List<MessageDescriptor> warnings) {
        if (credential == null) {
            throw new NullPointerException("credential is marked @NonNull but is null");
        }
        if (principal == null) {
            throw new NullPointerException("principal is marked @NonNull but is null");
        }
        return new DefaultAuthenticationHandlerExecutionResult(this, (CredentialMetaData)new BasicCredentialMetaData(credential), principal, warnings);
    }

    protected AuthenticationHandlerExecutionResult createHandlerResult(@NonNull Credential credential, @NonNull Principal principal) {
        if (credential == null) {
            throw new NullPointerException("credential is marked @NonNull but is null");
        }
        if (principal == null) {
            throw new NullPointerException("principal is marked @NonNull but is null");
        }
        return new DefaultAuthenticationHandlerExecutionResult(this, (CredentialMetaData)new BasicCredentialMetaData(credential), principal, new ArrayList<MessageDescriptor>(0));
    }
}

