/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.adaptive;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdaptiveAuthenticationPolicy
implements AdaptiveAuthenticationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAdaptiveAuthenticationPolicy.class);
    private final GeoLocationService geoLocationService;
    private final AdaptiveAuthenticationProperties adaptiveAuthenticationProperties;

    public boolean apply(String userAgent, GeoLocationRequest location) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo == null || StringUtils.isBlank((CharSequence)userAgent)) {
            LOGGER.warn("No client IP or user-agent was provided. Skipping adaptive authentication policy...");
            return true;
        }
        String clientIp = clientInfo.getClientIpAddress();
        LOGGER.debug("Located client IP address as [{}]", (Object)clientIp);
        if (this.isClientIpAddressRejected(clientIp)) {
            LOGGER.warn("Client IP [{}] is rejected for authentication", (Object)clientIp);
            return false;
        }
        if (this.isUserAgentRejected(userAgent)) {
            LOGGER.warn("User agent [{}] is rejected for authentication", (Object)userAgent);
            return false;
        }
        LOGGER.debug("User agent [{}] is authorized to proceed", (Object)userAgent);
        if (this.geoLocationService != null && location != null && StringUtils.isNotBlank((CharSequence)clientIp) && StringUtils.isNotBlank((CharSequence)this.adaptiveAuthenticationProperties.getRejectCountries())) {
            GeoLocationResponse loc = this.geoLocationService.locate(clientIp, location);
            if (loc != null) {
                LOGGER.debug("Determined geolocation to be [{}]", (Object)loc);
                if (this.isGeoLocationCountryRejected(loc)) {
                    LOGGER.warn("Client [{}] is rejected for authentication", (Object)clientIp);
                    return false;
                }
            } else {
                LOGGER.info("Could not determine geolocation for [{}]", (Object)clientIp);
            }
        }
        LOGGER.debug("Adaptive authentication policy has authorized client [{}] to proceed.", (Object)clientIp);
        return true;
    }

    private boolean isClientIpAddressRejected(String clientIp) {
        return StringUtils.isNotBlank((CharSequence)this.adaptiveAuthenticationProperties.getRejectIpAddresses()) && Pattern.compile(this.adaptiveAuthenticationProperties.getRejectIpAddresses()).matcher(clientIp).find();
    }

    private boolean isGeoLocationCountryRejected(GeoLocationResponse finalLoc) {
        return StringUtils.isNotBlank((CharSequence)this.adaptiveAuthenticationProperties.getRejectCountries()) && Pattern.compile(this.adaptiveAuthenticationProperties.getRejectCountries()).matcher(finalLoc.build()).find();
    }

    private boolean isUserAgentRejected(String userAgent) {
        return StringUtils.isNotBlank((CharSequence)this.adaptiveAuthenticationProperties.getRejectBrowsers()) && Pattern.compile(this.adaptiveAuthenticationProperties.getRejectBrowsers()).matcher(userAgent).find();
    }

    @Generated
    public DefaultAdaptiveAuthenticationPolicy(GeoLocationService geoLocationService, AdaptiveAuthenticationProperties adaptiveAuthenticationProperties) {
        this.geoLocationService = geoLocationService;
        this.adaptiveAuthenticationProperties = adaptiveAuthenticationProperties;
    }
}

