/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OneTimeTokenAccount
implements Serializable,
Comparable<OneTimeTokenAccount>,
Cloneable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OneTimeTokenAccount.class);
    private static final long serialVersionUID = -8289105320642735252L;
    @javax.persistence.Id
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id = -1L;
    @Column(nullable=false, length=2048)
    private String secretKey;
    @Column(nullable=false)
    private int validationCode;
    @ElementCollection
    @CollectionTable(name="scratch_codes", joinColumns={@JoinColumn(name="username")})
    @Column(nullable=false)
    private List<Integer> scratchCodes = new ArrayList<Integer>();
    @Column(nullable=false, unique=true)
    private String username;
    @Column
    private ZonedDateTime registrationDate = ZonedDateTime.now(ZoneOffset.UTC);

    public OneTimeTokenAccount() {
        this.setId(System.currentTimeMillis());
    }

    @JsonCreator
    public OneTimeTokenAccount(@JsonProperty(value="username") String username, @JsonProperty(value="secretKey") String secretKey, @JsonProperty(value="validationCode") int validationCode, @JsonProperty(value="scratchCodes") List<Integer> scratchCodes) {
        this();
        this.secretKey = secretKey;
        this.validationCode = validationCode;
        this.scratchCodes = scratchCodes;
        this.username = username;
    }

    @Override
    public int compareTo(OneTimeTokenAccount o) {
        return new CompareToBuilder().append(this.scratchCodes, o.getScratchCodes()).append(this.validationCode, o.getValidationCode()).append((Object)this.secretKey, (Object)o.getSecretKey()).append((Object)this.username, (Object)o.getUsername()).build();
    }

    public OneTimeTokenAccount clone() {
        return (OneTimeTokenAccount)super.clone();
    }

    @Generated
    public String toString() {
        return "OneTimeTokenAccount(id=" + this.id + ", secretKey=" + this.secretKey + ", validationCode=" + this.validationCode + ", scratchCodes=" + this.scratchCodes + ", username=" + this.username + ", registrationDate=" + this.registrationDate + ")";
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public int getValidationCode() {
        return this.validationCode;
    }

    @Generated
    public List<Integer> getScratchCodes() {
        return this.scratchCodes;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public ZonedDateTime getRegistrationDate() {
        return this.registrationDate;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setValidationCode(int validationCode) {
        this.validationCode = validationCode;
    }

    @Generated
    public void setScratchCodes(List<Integer> scratchCodes) {
        this.scratchCodes = scratchCodes;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setRegistrationDate(ZonedDateTime registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OneTimeTokenAccount)) {
            return false;
        }
        OneTimeTokenAccount other = (OneTimeTokenAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        String this$secretKey = this.secretKey;
        String other$secretKey = other.secretKey;
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        if (this.validationCode != other.validationCode) {
            return false;
        }
        List<Integer> this$scratchCodes = this.scratchCodes;
        List<Integer> other$scratchCodes = other.scratchCodes;
        if (this$scratchCodes == null ? other$scratchCodes != null : !((Object)this$scratchCodes).equals(other$scratchCodes)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        ZonedDateTime this$registrationDate = this.registrationDate;
        ZonedDateTime other$registrationDate = other.registrationDate;
        return !(this$registrationDate == null ? other$registrationDate != null : !((Object)this$registrationDate).equals(other$registrationDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OneTimeTokenAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.id;
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $secretKey = this.secretKey;
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        result = result * 59 + this.validationCode;
        List<Integer> $scratchCodes = this.scratchCodes;
        result = result * 59 + ($scratchCodes == null ? 43 : ((Object)$scratchCodes).hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        ZonedDateTime $registrationDate = this.registrationDate;
        result = result * 59 + ($registrationDate == null ? 43 : ((Object)$registrationDate).hashCode());
        return result;
    }
}

