/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.http.ssl.SSLContexts;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultCasSslContext {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasSslContext.class);
    private static final String ALG_NAME_PKIX = "PKIX";
    private final SSLContext sslContext;

    public DefaultCasSslContext(Resource trustStoreFile, String trustStorePassword, String trustStoreType) {
        KeyStore casTrustStore = KeyStore.getInstance(trustStoreType);
        char[] trustStorePasswordCharArray = trustStorePassword.toCharArray();
        try (InputStream casStream = trustStoreFile.getInputStream();){
            casTrustStore.load(casStream, trustStorePasswordCharArray);
        }
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509KeyManager customKeyManager = DefaultCasSslContext.getKeyManager(ALG_NAME_PKIX, casTrustStore, trustStorePasswordCharArray);
        X509KeyManager jvmKeyManager = DefaultCasSslContext.getKeyManager(defaultAlgorithm, null, null);
        String defaultTrustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        Collection<X509TrustManager> customTrustManager = DefaultCasSslContext.getTrustManager(ALG_NAME_PKIX, casTrustStore);
        Collection<X509TrustManager> jvmTrustManagers = DefaultCasSslContext.getTrustManager(defaultTrustAlgorithm, null);
        KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager(CollectionUtils.wrapList((Object[])new X509KeyManager[]{jvmKeyManager, customKeyManager}))};
        ArrayList<X509TrustManager> allManagers = new ArrayList<X509TrustManager>(customTrustManager);
        allManagers.addAll(jvmTrustManagers);
        TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager(allManagers)};
        this.sslContext = SSLContexts.custom().useProtocol("SSL").build();
        this.sslContext.init(keyManagers, trustManagers, null);
    }

    private static X509KeyManager getKeyManager(String algorithm, KeyStore keystore, char[] password) throws Exception {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keystore, password);
        return (X509KeyManager)factory.getKeyManagers()[0];
    }

    private static Collection<X509TrustManager> getTrustManager(String algorithm, KeyStore keystore) throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        return Arrays.stream(factory.getTrustManagers()).filter(e -> e instanceof X509TrustManager).map(X509TrustManager.class::cast).collect(Collectors.toList());
    }

    @Generated
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private final List<X509TrustManager> trustManagers;

        CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            boolean trusted = this.trustManagers.stream().anyMatch(trustManager -> {
                try {
                    trustManager.checkClientTrusted(chain, authType);
                    return true;
                }
                catch (CertificateException e) {
                    String msg = "Unable to trust the client certificates [%s] for auth type [%s]: [%s]";
                    LOGGER.debug(String.format("Unable to trust the client certificates [%s] for auth type [%s]: [%s]", Arrays.stream(chain).map(Certificate::toString).collect(Collectors.toSet()), authType, e.getMessage()), (Throwable)e);
                    return false;
                }
            });
            if (!trusted) {
                throw new CertificateException("None of the TrustManagers can trust this client certificate chain");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            boolean trusted = this.trustManagers.stream().anyMatch(trustManager -> {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return true;
                }
                catch (CertificateException e) {
                    String msg = "Unable to trust the server certificates [%s] for auth type [%s]: [%s]";
                    LOGGER.debug(String.format("Unable to trust the server certificates [%s] for auth type [%s]: [%s]", Arrays.stream(chain).map(Certificate::toString).collect(Collectors.toSet()), authType, e.getMessage()), (Throwable)e);
                    return false;
                }
            });
            if (!trusted) {
                throw new CertificateException("None of the TrustManagers trust this server certificate chain");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList certificates = new ArrayList();
            this.trustManagers.forEach(trustManager -> certificates.addAll(CollectionUtils.wrapList((Object[])trustManager.getAcceptedIssuers())));
            return certificates.toArray(new X509Certificate[0]);
        }
    }

    private static class CompositeX509KeyManager
    implements X509KeyManager {
        private final List<X509KeyManager> keyManagers;

        CompositeX509KeyManager(List<X509KeyManager> keyManagers) {
            this.keyManagers = keyManagers;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyManagers.stream().map(keyManager -> keyManager.chooseClientAlias(keyType, issuers, socket)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyManagers.stream().map(keyManager -> keyManager.chooseServerAlias(keyType, issuers, socket)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManagers.stream().map(keyManager -> keyManager.getPrivateKey(alias)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManagers.stream().map(keyManager -> keyManager.getCertificateChain(alias)).filter(chain -> chain != null && ((X509Certificate[])chain).length > 0).findFirst().orElse(null);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            ArrayList aliases = new ArrayList();
            this.keyManagers.forEach(keyManager -> aliases.addAll(CollectionUtils.wrapList((Object[])keyManager.getClientAliases(keyType, issuers))));
            return aliases.toArray(new String[0]);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            ArrayList aliases = new ArrayList();
            this.keyManagers.forEach(keyManager -> aliases.addAll(CollectionUtils.wrapList((Object[])keyManager.getServerAliases(keyType, issuers))));
            return aliases.toArray(new String[0]);
        }
    }
}

