/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationPreProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;

public class DefaultAuthenticationEventExecutionPlan
implements AuthenticationEventExecutionPlan {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationEventExecutionPlan.class);
    private final List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulatorList = new ArrayList<AuthenticationMetaDataPopulator>();
    private final List<AuthenticationPostProcessor> authenticationPostProcessors = new ArrayList<AuthenticationPostProcessor>();
    private final List<AuthenticationPreProcessor> authenticationPreProcessors = new ArrayList<AuthenticationPreProcessor>();
    private final List<AuthenticationPolicy> authenticationPolicies = new ArrayList<AuthenticationPolicy>();
    private final List<AuthenticationHandlerResolver> authenticationHandlerResolvers = new ArrayList<AuthenticationHandlerResolver>();
    private final Map<AuthenticationHandler, PrincipalResolver> authenticationHandlerPrincipalResolverMap = new LinkedHashMap<AuthenticationHandler, PrincipalResolver>();

    public void registerAuthenticationHandler(AuthenticationHandler handler) {
        this.registerAuthenticationHandlerWithPrincipalResolver(handler, null);
    }

    public void registerAuthenticationHandlerWithPrincipalResolver(AuthenticationHandler handler, PrincipalResolver principalResolver) {
        if (principalResolver == null) {
            LOGGER.debug("Registering handler [{}] with no principal resolver into the execution plan", (Object)handler.getName());
        } else {
            LOGGER.debug("Registering handler [{}] principal resolver [{}] into the execution plan", (Object)handler.getName(), (Object)principalResolver);
        }
        this.authenticationHandlerPrincipalResolverMap.put(handler, principalResolver);
    }

    public void registerAuthenticationHandlerWithPrincipalResolver(Map<AuthenticationHandler, PrincipalResolver> plan) {
        plan.forEach(this::registerAuthenticationHandlerWithPrincipalResolver);
    }

    public void registerAuthenticationHandlerWithPrincipalResolvers(Collection<AuthenticationHandler> handlers, PrincipalResolver principalResolver) {
        handlers.forEach(h -> this.registerAuthenticationHandlerWithPrincipalResolver((AuthenticationHandler)h, principalResolver));
    }

    public void registerAuthenticationHandlerWithPrincipalResolvers(List<AuthenticationHandler> handlers, List<PrincipalResolver> principalResolver) {
        if (handlers.size() != principalResolver.size()) {
            LOGGER.error("Total number of authentication handlers must match the number of provided principal resolvers");
            return;
        }
        for (int i = 0; i < handlers.size(); ++i) {
            this.registerAuthenticationHandlerWithPrincipalResolver(handlers.get(i), principalResolver.get(i));
        }
    }

    public void registerMetadataPopulator(AuthenticationMetaDataPopulator populator) {
        LOGGER.debug("Registering metadata populator [{}] into the execution plan", (Object)populator);
        this.authenticationMetaDataPopulatorList.add(populator);
    }

    public void registerMetadataPopulators(Collection<AuthenticationMetaDataPopulator> populators) {
        populators.forEach(this::registerMetadataPopulator);
    }

    public Collection<AuthenticationMetaDataPopulator> getAuthenticationMetadataPopulators(AuthenticationTransaction transaction) {
        ArrayList<AuthenticationMetaDataPopulator> list = new ArrayList<AuthenticationMetaDataPopulator>(this.authenticationMetaDataPopulatorList);
        OrderComparator.sort(list);
        LOGGER.debug("Sorted and registered metadata populators for this transaction are [{}]", list);
        return list;
    }

    public Set<AuthenticationHandler> getAuthenticationHandlersForTransaction(AuthenticationTransaction transaction) {
        Object[] handlers = this.authenticationHandlerPrincipalResolverMap.keySet().toArray(new AuthenticationHandler[0]);
        OrderComparator.sortIfNecessary((Object)handlers);
        return new LinkedHashSet<AuthenticationHandler>(CollectionUtils.wrapList((Object[])handlers));
    }

    public PrincipalResolver getPrincipalResolverForAuthenticationTransaction(AuthenticationHandler handler, AuthenticationTransaction transaction) {
        return this.authenticationHandlerPrincipalResolverMap.get(handler);
    }

    public void registerAuthenticationPostProcessor(AuthenticationPostProcessor processor) {
        LOGGER.debug("Registering authentication post processor [{}] into the execution plan", (Object)processor);
        this.authenticationPostProcessors.add(processor);
    }

    public Collection<AuthenticationPostProcessor> getAuthenticationPostProcessors(AuthenticationTransaction transaction) {
        ArrayList<AuthenticationPostProcessor> list = new ArrayList<AuthenticationPostProcessor>(this.authenticationPostProcessors);
        OrderComparator.sort(list);
        LOGGER.debug("Sorted and registered authentication post processors for this transaction are [{}]", list);
        return list;
    }

    public void registerAuthenticationPreProcessor(AuthenticationPreProcessor processor) {
        LOGGER.debug("Registering authentication pre processor [{}] into the execution plan", (Object)processor);
        this.authenticationPreProcessors.add(processor);
    }

    public Collection<AuthenticationPreProcessor> getAuthenticationPreProcessors(AuthenticationTransaction transaction) {
        ArrayList<AuthenticationPreProcessor> list = new ArrayList<AuthenticationPreProcessor>(this.authenticationPreProcessors);
        OrderComparator.sort(list);
        LOGGER.debug("Sorted and registered authentication pre processors for this transaction are [{}]", list);
        return list;
    }

    public void registerAuthenticationPolicy(AuthenticationPolicy authenticationPolicy) {
        this.authenticationPolicies.add(authenticationPolicy);
    }

    public void registerAuthenticationHandlerResolver(AuthenticationHandlerResolver handlerResolver) {
        this.authenticationHandlerResolvers.add(handlerResolver);
    }

    public Collection<AuthenticationPolicy> getAuthenticationPolicies(AuthenticationTransaction transaction) {
        ArrayList<AuthenticationPolicy> list = new ArrayList<AuthenticationPolicy>(this.authenticationPolicies);
        OrderComparator.sort(list);
        LOGGER.debug("Sorted and registered authentication policies for this transaction are [{}]", list);
        return list;
    }

    public Collection<AuthenticationHandlerResolver> getAuthenticationHandlerResolvers(AuthenticationTransaction transaction) {
        ArrayList<AuthenticationHandlerResolver> list = new ArrayList<AuthenticationHandlerResolver>(this.authenticationHandlerResolvers);
        OrderComparator.sort(list);
        LOGGER.debug("Sorted and registered authentication handler resolvers for this transaction are [{}]", list);
        return list;
    }
}

