/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationBuilder
implements AuthenticationBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationBuilder.class);
    private static final long serialVersionUID = -8504842011648432398L;
    private Principal principal;
    private final List<CredentialMetaData> credentials = new ArrayList<CredentialMetaData>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, AuthenticationHandlerExecutionResult> successes = new LinkedHashMap<String, AuthenticationHandlerExecutionResult>();
    private final Map<String, Throwable> failures = new LinkedHashMap<String, Throwable>();
    private ZonedDateTime authenticationDate = ZonedDateTime.now(ZoneOffset.UTC);

    public DefaultAuthenticationBuilder() {
    }

    public DefaultAuthenticationBuilder(Principal p) {
        this();
        this.principal = p;
    }

    public AuthenticationBuilder setAuthenticationDate(ZonedDateTime d) {
        if (d != null) {
            this.authenticationDate = d;
        }
        return this;
    }

    public AuthenticationBuilder addCredentials(List<CredentialMetaData> credentials) {
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder setPrincipal(Principal p) {
        this.principal = p;
        return this;
    }

    public AuthenticationBuilder setCredentials(@NonNull List<CredentialMetaData> credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked @NonNull but is null");
        }
        this.credentials.clear();
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder addCredential(CredentialMetaData credential) {
        this.credentials.add(credential);
        return this;
    }

    public AuthenticationBuilder setAttributes(Map<String, Object> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
        return this;
    }

    public AuthenticationBuilder mergeAttribute(String key, Object value) {
        Object currentValue = this.attributes.get(key);
        if (currentValue == null) {
            return this.addAttribute(key, value);
        }
        Set collection = CollectionUtils.toCollection((Object)currentValue);
        collection.addAll(CollectionUtils.toCollection((Object)value));
        return this.addAttribute(key, collection);
    }

    public boolean hasAttribute(String name, Predicate<Object> predicate) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.get(name);
            Set valueCol = CollectionUtils.toCollection((Object)value);
            return valueCol.stream().anyMatch(predicate);
        }
        return false;
    }

    public AuthenticationBuilder addAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public AuthenticationBuilder setSuccesses(@NonNull Map<String, AuthenticationHandlerExecutionResult> successes) {
        if (successes == null) {
            throw new NullPointerException("successes is marked @NonNull but is null");
        }
        this.successes.clear();
        return this.addSuccesses(successes);
    }

    public AuthenticationBuilder addSuccesses(Map<String, AuthenticationHandlerExecutionResult> successes) {
        successes.entrySet().forEach(entry -> this.addSuccess((String)entry.getKey(), (AuthenticationHandlerExecutionResult)entry.getValue()));
        return this;
    }

    public AuthenticationBuilder addSuccess(String key, AuthenticationHandlerExecutionResult value) {
        LOGGER.debug("Recording authentication handler result success under key [{}]", (Object)key);
        if (this.successes.containsKey(key)) {
            LOGGER.debug("Key mapped to authentication handler result [{}] is already recorded in the list of successful attempts. Overriding...", (Object)key);
        }
        this.successes.put(key, value);
        return this;
    }

    public AuthenticationBuilder setFailures(@NonNull Map<String, Throwable> failures) {
        if (failures == null) {
            throw new NullPointerException("failures is marked @NonNull but is null");
        }
        this.failures.clear();
        return this.addFailures(failures);
    }

    public AuthenticationBuilder addFailures(Map<String, Throwable> failures) {
        failures.entrySet().forEach(entry -> this.addFailure((String)entry.getKey(), (Throwable)entry.getValue()));
        return this;
    }

    public AuthenticationBuilder addFailure(String key, Throwable value) {
        LOGGER.debug("Recording authentication handler failure under key [{}]", (Object)key);
        if (this.successes.containsKey(key)) {
            String newKey = key + System.currentTimeMillis();
            LOGGER.debug("Key mapped to authentication handler failure [{}] is recorded in the list of failed attempts. Overriding with [{}]", (Object)key, (Object)newKey);
            this.failures.put(newKey, value);
        } else {
            this.failures.put(key, value);
        }
        return this;
    }

    public Authentication build() {
        return new DefaultAuthentication(this.authenticationDate, this.credentials, this.principal, this.attributes, this.successes, this.failures);
    }

    public static AuthenticationBuilder newInstance(Authentication source) {
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(source.getPrincipal());
        builder.setAuthenticationDate(source.getAuthenticationDate());
        builder.setCredentials(source.getCredentials());
        builder.setSuccesses(source.getSuccesses());
        builder.setFailures(source.getFailures());
        builder.setAttributes(source.getAttributes());
        return builder;
    }

    public static AuthenticationBuilder newInstance() {
        return new DefaultAuthenticationBuilder();
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public List<CredentialMetaData> getCredentials() {
        return this.credentials;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, AuthenticationHandlerExecutionResult> getSuccesses() {
        return this.successes;
    }

    @Generated
    public Map<String, Throwable> getFailures() {
        return this.failures;
    }

    @Generated
    public ZonedDateTime getAuthenticationDate() {
        return this.authenticationDate;
    }
}

