/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.support.password.DefaultPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.GroovyPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.RejectResultCodePasswordPolicyHandlingStrategy;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.CollectionUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public final class CoreAuthenticationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreAuthenticationUtils.class);

    public static Map<String, Object> transformPrincipalAttributesListIntoMap(List<String> list) {
        Multimap<String, Object> map = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap(list);
        return CollectionUtils.wrap(map);
    }

    public static Multimap<String, Object> transformPrincipalAttributesListIntoMultiMap(List<String> list) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (list.isEmpty()) {
            LOGGER.debug("No principal attributes are defined");
        } else {
            list.forEach(arg_0 -> CoreAuthenticationUtils.lambda$transformPrincipalAttributesListIntoMultiMap$0((Multimap)multimap, arg_0));
        }
        return multimap;
    }

    public static Predicate<Credential> newCredentialSelectionPredicate(String selectionCriteria) {
        try {
            DefaultResourceLoader loader;
            Resource resource;
            if (StringUtils.isBlank((CharSequence)selectionCriteria)) {
                return credential -> true;
            }
            if (selectionCriteria.endsWith(".groovy") && (resource = (loader = new DefaultResourceLoader()).getResource(selectionCriteria)) != null) {
                String script = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                Class clz = AccessController.doPrivileged(() -> {
                    GroovyClassLoader classLoader = new GroovyClassLoader(Beans.class.getClassLoader(), new CompilerConfiguration(), true);
                    return classLoader.parseClass(script);
                });
                return (Predicate)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class predicateClazz = ClassUtils.getClass((String)selectionCriteria);
            return (Predicate)predicateClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Predicate<String> predicate = Pattern.compile(selectionCriteria).asPredicate();
            return credential -> predicate.test(credential.getId());
        }
    }

    public static AuthenticationPasswordPolicyHandlingStrategy newPasswordPolicyHandlingStrategy(PasswordPolicyProperties properties) {
        if (properties.getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.REJECT_RESULT_CODE) {
            LOGGER.debug("Created password policy handling strategy based on blacklisted authentication result codes");
            return new RejectResultCodePasswordPolicyHandlingStrategy();
        }
        Resource location = properties.getGroovy().getLocation();
        if (properties.getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.GROOVY && location != null) {
            LOGGER.debug("Created password policy handling strategy based on Groovy script [{}]", (Object)location);
            return new GroovyPasswordPolicyHandlingStrategy(location);
        }
        LOGGER.debug("Created default password policy handling strategy");
        return new DefaultPasswordPolicyHandlingStrategy();
    }

    @Generated
    private CoreAuthenticationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$transformPrincipalAttributesListIntoMultiMap$0(Multimap multimap, String a) {
        String attributeName = a.trim();
        if (attributeName.contains(":")) {
            List attrCombo = Splitter.on((String)":").splitToList((CharSequence)attributeName);
            String name = ((String)attrCombo.get(0)).trim();
            String value = ((String)attrCombo.get(1)).trim();
            LOGGER.debug("Mapped principal attribute name [{}] to [{}]", (Object)name, (Object)value);
            multimap.put((Object)name, (Object)value);
        } else {
            LOGGER.debug("Mapped principal attribute name [{}]", (Object)attributeName);
            multimap.put((Object)attributeName, (Object)attributeName);
        }
    }
}

