/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;
import org.apereo.cas.authentication.DefaultCasSslContext;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(value="casCoreHttpConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Order(value=-2147483648)
@AutoConfigureBefore(value={CasCoreAuthenticationConfiguration.class})
public class CasCoreHttpConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"trustStoreSslSocketFactory"})
    @Bean
    public SSLConnectionSocketFactory trustStoreSslSocketFactory() {
        return new SSLConnectionSocketFactory(this.sslContext());
    }

    @ConditionalOnMissingBean(name={"sslContext"})
    @Bean
    public SSLContext sslContext() {
        try {
            HttpClientProperties.Truststore client = this.casProperties.getHttpClient().getTruststore();
            if (client.getFile() != null && client.getFile().exists() && StringUtils.isNotBlank((CharSequence)client.getPsw())) {
                DefaultCasSslContext ctx = new DefaultCasSslContext(client.getFile(), client.getPsw(), KeyStore.getDefaultType());
                return ctx.getSslContext();
            }
            return SSLContexts.createSystemDefault();
        }
        catch (Exception e) {
            throw new BeanCreationException(e.getMessage(), (Throwable)e);
        }
    }

    @ConditionalOnMissingBean(name={"httpClient"})
    @Bean
    public FactoryBean<SimpleHttpClient> httpClient() {
        SimpleHttpClientFactoryBean.DefaultHttpClient c = new SimpleHttpClientFactoryBean.DefaultHttpClient();
        c.setConnectionTimeout(this.casProperties.getHttpClient().getConnectionTimeout());
        c.setReadTimeout((int)this.casProperties.getHttpClient().getReadTimeout());
        return c;
    }

    @ConditionalOnMissingBean(name={"noRedirectHttpClient"})
    @Bean
    public HttpClient noRedirectHttpClient() throws Exception {
        return this.getHttpClient(false);
    }

    @ConditionalOnMissingBean(name={"supportsTrustStoreSslSocketFactoryHttpClient"})
    @Bean
    public HttpClient supportsTrustStoreSslSocketFactoryHttpClient() throws Exception {
        return this.getHttpClient(true);
    }

    @ConditionalOnMissingBean(name={"hostnameVerifier"})
    @Bean
    public HostnameVerifier hostnameVerifier() {
        if (this.casProperties.getHttpClient().getHostNameVerifier().equalsIgnoreCase("none")) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return new DefaultHostnameVerifier();
    }

    private HttpClient getHttpClient(boolean redirectEnabled) throws Exception {
        SimpleHttpClientFactoryBean.DefaultHttpClient c = new SimpleHttpClientFactoryBean.DefaultHttpClient();
        c.setConnectionTimeout(this.casProperties.getHttpClient().getConnectionTimeout());
        c.setReadTimeout((int)this.casProperties.getHttpClient().getReadTimeout());
        c.setRedirectsEnabled(redirectEnabled);
        c.setCircularRedirectsAllowed(redirectEnabled);
        c.setSslSocketFactory(this.trustStoreSslSocketFactory());
        c.setHostnameVerifier(this.hostnameVerifier());
        return c.getObject();
    }
}

