/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.DefaultAuthenticationContextValidator;
import org.apereo.cas.authentication.DefaultAuthenticationSystemSupport;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.RegisteredServiceAuthenticationHandlerResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(value="casCoreAuthenticationSupportConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationSupportConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"authenticationContextValidator"})
    public AuthenticationContextValidator authenticationContextValidator() {
        MultifactorAuthenticationProperties mfa = this.casProperties.getAuthn().getMfa();
        String contextAttribute = mfa.getAuthenticationContextAttribute();
        String failureMode = mfa.getGlobalFailureMode();
        String authnAttributeName = mfa.getTrusted().getAuthenticationContextAttribute();
        return new DefaultAuthenticationContextValidator(contextAttribute, failureMode, authnAttributeName);
    }

    @Autowired
    @Bean
    @Lazy
    @ConditionalOnMissingBean(name={"registeredServiceAuthenticationHandlerResolver"})
    public AuthenticationHandlerResolver registeredServiceAuthenticationHandlerResolver(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return new RegisteredServiceAuthenticationHandlerResolver(servicesManager);
    }

    @Autowired
    @Bean
    public AuthenticationSystemSupport defaultAuthenticationSystemSupport(@Qualifier(value="principalElectionStrategy") PrincipalElectionStrategy principalElectionStrategy, @Qualifier(value="authenticationTransactionManager") AuthenticationTransactionManager authenticationTransactionManager) {
        return new DefaultAuthenticationSystemSupport(authenticationTransactionManager, principalElectionStrategy);
    }
}

