/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AcceptUsersAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.apereo.cas.authentication.handler.support.JaasAuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.ProxyingPrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.generic.AcceptAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.http.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreAuthenticationHandlersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationHandlersConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="supportsTrustStoreSslSocketFactoryHttpClient")
    private HttpClient supportsTrustStoreSslSocketFactoryHttpClient;
    @Autowired(required=false)
    @Qualifier(value="acceptPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration acceptPasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="jaasPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration jaasPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"jaasPrincipalFactory"})
    @Bean
    public PrincipalFactory jaasPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    public AuthenticationHandler proxyAuthenticationHandler() {
        return new HttpBasedServiceCredentialsAuthenticationHandler(null, this.servicesManager, this.proxyPrincipalFactory(), Integer.MIN_VALUE, this.supportsTrustStoreSslSocketFactoryHttpClient);
    }

    @ConditionalOnMissingBean(name={"proxyPrincipalFactory"})
    @Bean
    public PrincipalFactory proxyPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"proxyPrincipalResolver"})
    @Bean
    public PrincipalResolver proxyPrincipalResolver() {
        return new ProxyingPrincipalResolver(this.proxyPrincipalFactory());
    }

    @RefreshScope
    @Bean
    public AuthenticationHandler acceptUsersAuthenticationHandler() {
        AcceptAuthenticationProperties props = this.casProperties.getAuthn().getAccept();
        AcceptUsersAuthenticationHandler h = new AcceptUsersAuthenticationHandler(props.getName(), this.servicesManager, this.acceptUsersPrincipalFactory(), null, this.getParsedUsers());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder(props.getPasswordEncoder()));
        if (this.acceptPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.acceptPasswordPolicyConfiguration);
        }
        h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate(props.getCredentialCriteria()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer(props.getPrincipalTransformation()));
        return h;
    }

    @ConditionalOnMissingBean(name={"acceptUsersPrincipalFactory"})
    @Bean
    public PrincipalFactory acceptUsersPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    private Map<String, String> getParsedUsers() {
        Pattern pattern = Pattern.compile("::");
        String usersProperty = this.casProperties.getAuthn().getAccept().getUsers();
        if (StringUtils.isNotBlank((CharSequence)usersProperty) && usersProperty.contains(pattern.pattern())) {
            return Stream.of(usersProperty.split(",")).map(pattern::split).collect(Collectors.toMap(userAndPassword -> userAndPassword[0], userAndPassword -> userAndPassword[1]));
        }
        return new HashMap<String, String>(0);
    }

    @ConditionalOnMissingBean(name={"proxyAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer proxyAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.proxyAuthenticationHandler(), this.proxyPrincipalResolver());
    }

    @Configuration(value="jaasAuthenticationConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class JaasAuthenticationConfiguration {
        @Autowired
        @Qualifier(value="personDirectoryPrincipalResolver")
        private PrincipalResolver personDirectoryPrincipalResolver;

        @ConditionalOnMissingBean(name={"jaasAuthenticationHandlers"})
        @RefreshScope
        @Bean
        public List<AuthenticationHandler> jaasAuthenticationHandlers() {
            return CasCoreAuthenticationHandlersConfiguration.this.casProperties.getAuthn().getJaas().stream().filter(jaas -> StringUtils.isNotBlank((CharSequence)jaas.getRealm())).map(jaas -> {
                JaasAuthenticationHandler h = new JaasAuthenticationHandler(jaas.getName(), CasCoreAuthenticationHandlersConfiguration.this.servicesManager, CasCoreAuthenticationHandlersConfiguration.this.jaasPrincipalFactory(), null);
                h.setKerberosKdcSystemProperty(jaas.getKerberosKdcSystemProperty());
                h.setKerberosRealmSystemProperty(jaas.getKerberosRealmSystemProperty());
                h.setRealm(jaas.getRealm());
                h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder(jaas.getPasswordEncoder()));
                if (CasCoreAuthenticationHandlersConfiguration.this.jaasPasswordPolicyConfiguration != null) {
                    h.setPasswordPolicyConfiguration(CasCoreAuthenticationHandlersConfiguration.this.jaasPasswordPolicyConfiguration);
                }
                h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer(jaas.getPrincipalTransformation()));
                h.setCredentialSelectionPredicate(CoreAuthenticationUtils.newCredentialSelectionPredicate(jaas.getCredentialCriteria()));
                return h;
            }).collect(Collectors.toList());
        }

        @ConditionalOnMissingBean(name={"jaasAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        public AuthenticationEventExecutionPlanConfigurer jaasAuthenticationEventExecutionPlanConfigurer() {
            return plan -> plan.registerAuthenticationHandlerWithPrincipalResolvers(this.jaasAuthenticationHandlers(), this.personDirectoryPrincipalResolver);
        }
    }
}

