/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.DefaultAuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.DefaultAuthenticationTransactionManager;
import org.apereo.cas.authentication.PolicyBasedAuthenticationManager;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casCoreAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public AuthenticationTransactionManager authenticationTransactionManager(@Qualifier(value="casAuthenticationManager") AuthenticationManager authenticationManager) {
        return new DefaultAuthenticationTransactionManager(authenticationManager);
    }

    @ConditionalOnMissingBean(name={"casAuthenticationManager"})
    @Autowired
    @Bean
    public AuthenticationManager casAuthenticationManager(@Qualifier(value="authenticationPolicy") Collection<AuthenticationPolicy> authenticationPolicy, @Qualifier(value="registeredServiceAuthenticationHandlerResolver") AuthenticationHandlerResolver registeredServiceAuthenticationHandlerResolver, @Qualifier(value="authenticationEventExecutionPlan") AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
        return new PolicyBasedAuthenticationManager(authenticationEventExecutionPlan, registeredServiceAuthenticationHandlerResolver, authenticationPolicy, this.casProperties.getPersonDirectory().isPrincipalResolutionFailureFatal());
    }

    @ConditionalOnMissingBean(name={"authenticationEventExecutionPlan"})
    @Autowired
    @Bean
    public AuthenticationEventExecutionPlan authenticationEventExecutionPlan(List<AuthenticationEventExecutionPlanConfigurer> configurers) {
        DefaultAuthenticationEventExecutionPlan plan = new DefaultAuthenticationEventExecutionPlan();
        configurers.forEach(c -> {
            String name = StringUtils.removePattern((String)c.getClass().getSimpleName(), (String)"\\$.+");
            LOGGER.debug("Configuring authentication execution plan [{}]", (Object)name);
            c.configureAuthenticationExecutionPlan((AuthenticationEventExecutionPlan)plan);
        });
        return plan;
    }
}

