/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.apereo.services.persondir.support.BaseGroovyScriptDaoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class InternalGroovyScriptDao
extends BaseGroovyScriptDaoImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalGroovyScriptDao.class);
    private final ApplicationContext applicationContext;
    private final CasConfigurationProperties casProperties;

    public InternalGroovyScriptDao(ApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        this.applicationContext = applicationContext;
        this.casProperties = casProperties;
    }

    public Map<String, List<Object>> getPersonAttributesFromMultivaluedAttributes(Map<String, List<Object>> attributes) {
        List<Object> username;
        if (attributes.containsKey("username") && !(username = attributes.get("username")).isEmpty()) {
            HashMap<String, List<Object>> results = new HashMap<String, List<Object>>();
            Map<String, Object> attrs = this.getAttributesForUser(username.get(0).toString());
            LOGGER.debug("Groovy-based attributes found are [{}]", attrs);
            attrs.forEach((k, v) -> {
                ArrayList values = new ArrayList(CollectionUtils.toCollection((Object)v));
                LOGGER.debug("Adding Groovy-based attribute [{}] with value(s) [{}]", k, values);
                results.put((String)k, values);
            });
            return results;
        }
        return new HashMap<String, List<Object>>(0);
    }

    public Map<String, Object> getAttributesForUser(String uid) {
        HashMap<String, Object> finalAttributes = new HashMap<String, Object>();
        this.casProperties.getAuthn().getAttributeRepository().getGroovy().forEach(groovy -> {
            Object[] args = new Object[]{uid, LOGGER, this.casProperties, this.applicationContext};
            Map personAttributesMap = (Map)ScriptingUtils.executeGroovyScript((Resource)groovy.getLocation(), (Object[])args, Map.class);
            finalAttributes.putAll(personAttributesMap);
        });
        return finalAttributes;
    }
}

