/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.resolvers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.MergingPersonAttributeDaoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingPrincipalResolver
implements PrincipalResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainingPrincipalResolver.class);
    private final PrincipalFactory principalFactory = new DefaultPrincipalFactory();
    private List<PrincipalResolver> chain;

    public void setChain(List<PrincipalResolver> chain) {
        this.chain = chain;
    }

    public void setChain(PrincipalResolver ... chain) {
        this.chain = Arrays.stream(chain).collect(Collectors.toList());
    }

    public Principal resolve(Credential credential, Principal principal, AuthenticationHandler handler) {
        ArrayList principals = new ArrayList();
        this.chain.stream().filter(resolver -> resolver.supports(credential)).forEach(resolver -> {
            LOGGER.debug("Invoking principal resolver [{}]", resolver);
            Principal p = resolver.resolve(credential, principal, handler);
            if (p != null) {
                principals.add(p);
            }
        });
        if (principals.isEmpty()) {
            LOGGER.warn("None of the principal resolvers in the chain were able to produce a principal");
            return NullPrincipal.getInstance();
        }
        HashMap attributes = new HashMap();
        principals.forEach(p -> {
            if (p != null) {
                LOGGER.debug("Resolved principal [{}]", p);
                if (p.getAttributes() != null && !p.getAttributes().isEmpty()) {
                    LOGGER.debug("Adding attributes [{}] for the final principal", (Object)p.getAttributes());
                    attributes.putAll(p.getAttributes());
                }
            }
        });
        long count = principals.stream().map(p -> p.getId().trim().toLowerCase()).distinct().collect(Collectors.toSet()).size();
        if (count > 1L) {
            throw new PrincipalException("Resolved principals by the chain are not unique because principal resolvers have produced CAS principals with different identifiers which typically is the result of a configuration issue.", new HashMap(0), new HashMap(0));
        }
        String principalId = principal != null ? principal.getId() : ((Principal)principals.get(0)).getId();
        Principal finalPrincipal = this.principalFactory.createPrincipal(principalId, attributes);
        LOGGER.debug("Final principal constructed by the chain of resolvers is [{}]", (Object)finalPrincipal);
        return finalPrincipal;
    }

    public boolean supports(Credential credential) {
        return this.chain.get(0).supports(credential);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("chain", this.chain).toString();
    }

    public IPersonAttributeDao getAttributeRepository() {
        MergingPersonAttributeDaoImpl dao = new MergingPersonAttributeDaoImpl();
        dao.setPersonAttributeDaos(this.chain.stream().map(PrincipalResolver::getAttributeRepository).collect(Collectors.toList()));
        return dao;
    }
}

