/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimplePrincipal
implements Principal {
    private static final long serialVersionUID = -1255260750151385796L;
    @JsonProperty
    private String id;
    private Map<String, Object> attributes;

    private SimplePrincipal() {
        this.id = null;
        this.attributes = new HashMap<String, Object>();
    }

    private SimplePrincipal(String id) {
        this(id, new HashMap<String, Object>());
    }

    @JsonCreator
    protected SimplePrincipal(@JsonProperty(value="id") String id, @JsonProperty(value="attributes") Map<String, Object> attributes) {
        Assert.notNull((Object)id, (String)"Principal id cannot be null");
        this.id = id;
        this.attributes = attributes == null ? new HashMap<String, Object>() : attributes;
    }

    public Map<String, Object> getAttributes() {
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        attrs.putAll(this.attributes);
        return attrs;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(83, 31);
        builder.append((Object)this.id.toLowerCase());
        return builder.toHashCode();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SimplePrincipal rhs = (SimplePrincipal)obj;
        return StringUtils.equalsIgnoreCase((CharSequence)this.id, (CharSequence)rhs.getId());
    }
}

