/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class RestfulAuthenticationPolicy
implements AuthenticationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulAuthenticationPolicy.class);
    private final RestTemplate restTemplate;
    private final String endpoint;

    public RestfulAuthenticationPolicy(RestTemplate restTemplate, String endpoint) {
        this.restTemplate = restTemplate;
        this.endpoint = endpoint;
    }

    public boolean isSatisfiedBy(Authentication authentication) throws Exception {
        try {
            HttpHeaders acceptHeaders = new HttpHeaders();
            acceptHeaders.setAccept(CollectionUtils.wrap((Object)MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((Object)authentication.getPrincipal(), (MultiValueMap)acceptHeaders);
            LOGGER.warn("Checking authentication policy for [{}] via POST at [{}]", (Object)authentication.getPrincipal(), (Object)this.endpoint);
            ResponseEntity resp = this.restTemplate.exchange(this.endpoint, HttpMethod.POST, entity, String.class, new Object[0]);
            if (resp == null) {
                LOGGER.warn("[{}] returned no responses", (Object)this.endpoint);
                throw new GeneralSecurityException("No response returned from REST endpoint to determine authentication policy");
            }
            if (resp.getStatusCode() != HttpStatus.OK) {
                Exception ex = this.handleResponseStatusCode(resp.getStatusCode(), authentication.getPrincipal());
                throw new GeneralSecurityException(ex);
            }
            return true;
        }
        catch (HttpClientErrorException e) {
            Exception ex = this.handleResponseStatusCode(e.getStatusCode(), authentication.getPrincipal());
            throw new GeneralSecurityException(ex);
        }
    }

    private Exception handleResponseStatusCode(HttpStatus statusCode, Principal p) {
        if (statusCode == HttpStatus.FORBIDDEN || statusCode == HttpStatus.METHOD_NOT_ALLOWED) {
            return new AccountDisabledException("Could not authenticate forbidden account for " + p.getId());
        }
        if (statusCode == HttpStatus.UNAUTHORIZED) {
            return new FailedLoginException("Could not authenticate account for " + p.getId());
        }
        if (statusCode == HttpStatus.NOT_FOUND) {
            return new AccountNotFoundException("Could not locate account for " + p.getId());
        }
        if (statusCode == HttpStatus.LOCKED) {
            return new AccountLockedException("Could not authenticate locked account for " + p.getId());
        }
        if (statusCode == HttpStatus.PRECONDITION_FAILED) {
            return new AccountExpiredException("Could not authenticate expired account for " + p.getId());
        }
        if (statusCode == HttpStatus.PRECONDITION_REQUIRED) {
            return new AccountPasswordMustChangeException("Account password must change for " + p.getId());
        }
        return new FailedLoginException("Rest endpoint returned an unknown status code " + statusCode);
    }
}

