/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import java.security.GeneralSecurityException;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class GroovyScriptAuthenticationPolicy
implements AuthenticationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptAuthenticationPolicy.class);
    private final ResourceLoader resourceLoader;
    private final String script;

    public GroovyScriptAuthenticationPolicy(ResourceLoader resourceLoader, String script) {
        this.resourceLoader = resourceLoader;
        this.script = script;
    }

    public boolean isSatisfiedBy(Authentication auth) throws Exception {
        Exception ex;
        if (ScriptingUtils.isInlineGroovyScript((String)this.script)) {
            ex = (Exception)ScriptingUtils.executeGroovyShellScript((String)this.script, (Map)CollectionUtils.wrap((String)"principal", (Object)auth.getPrincipal(), (String)"logger", (Object)LOGGER));
        } else {
            Resource res = this.resourceLoader.getResource(this.script);
            ex = (Exception)ScriptingUtils.executeGroovyScript((Resource)res, (Object[])new Object[]{auth.getPrincipal(), LOGGER}, Exception.class);
        }
        if (ex != null) {
            throw new GeneralSecurityException(ex);
        }
        return true;
    }
}

