/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.policy;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyAuthenticationPolicy
implements AuthenticationPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnyAuthenticationPolicy.class);
    private boolean tryAll;

    public AnyAuthenticationPolicy() {
    }

    public AnyAuthenticationPolicy(boolean tryAll) {
        this.tryAll = tryAll;
    }

    public void setTryAll(boolean tryAll) {
        this.tryAll = tryAll;
    }

    public boolean isSatisfiedBy(Authentication authn) throws Exception {
        if (this.tryAll) {
            if (authn.getCredentials().size() != authn.getSuccesses().size() + authn.getFailures().size()) {
                LOGGER.warn("Number of provided credentials does not match the sum of authentication successes and failures");
                return false;
            }
            LOGGER.debug("Authentication policy is satisfied with all authentication transactions");
            return true;
        }
        if (!authn.getSuccesses().isEmpty()) {
            LOGGER.debug("Authentication policy is satisfied having found at least one authentication transactions");
            return true;
        }
        LOGGER.warn("Authentication policy has failed to find a successful authentication transaction");
        return false;
    }
}

