/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCredentialsMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheCredentialsMetaDataPopulator.class);
    private final CipherExecutor<String, String> cipherExecutor;

    public CacheCredentialsMetaDataPopulator() {
        this(null);
        LOGGER.warn("No cipher is specified to handle credential caching encryption");
    }

    public CacheCredentialsMetaDataPopulator(CipherExecutor cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        Credential credential = transaction.getCredential();
        LOGGER.debug("Processing request to capture the credential for [{}]", (Object)credential.getId());
        UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
        String psw = this.cipherExecutor == null ? c.getPassword() : (String)this.cipherExecutor.encode((Object)c.getPassword());
        builder.addAttribute("credential", (Object)psw);
        LOGGER.debug("Credential is added as the authentication attribute [{}] to the authentication", (Object)"credential");
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).toString();
    }
}

