/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.services.MultifactorAuthenticationProvider;

public class AuthenticationContextAttributeMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    private final String authenticationContextAttribute;
    private final AuthenticationHandler authenticationHandler;
    private final MultifactorAuthenticationProvider provider;

    public AuthenticationContextAttributeMetaDataPopulator(String authenticationContextAttribute, AuthenticationHandler authenticationHandler, MultifactorAuthenticationProvider provider) {
        this.authenticationContextAttribute = authenticationContextAttribute;
        this.authenticationHandler = authenticationHandler;
        this.provider = provider;
    }

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        if (builder.hasAttribute("authenticationMethod", obj -> obj.toString().equals(this.authenticationHandler.getName()))) {
            builder.mergeAttribute(this.authenticationContextAttribute, (Object)this.provider.getId());
        }
    }

    public boolean supports(Credential credential) {
        return this.authenticationHandler.supports(credential);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("authenticationContextAttribute", (Object)this.authenticationContextAttribute).append("authenticationHandler", (Object)this.authenticationHandler).append("provider", (Object)this.provider).toString();
    }
}

