/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class JaasAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaasAuthenticationHandler.class);
    private static final String SYS_PROP_KRB5_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERB5_KDC = "java.security.krb5.kdc";
    private String realm = "CAS";
    private String kerberosRealmSystemProperty;
    private String kerberosKdcSystemProperty;

    public JaasAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"Static Configuration cannot be null. Did you remember to specify \"java.security.auth.login.config\"?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        if (this.kerberosKdcSystemProperty != null) {
            LOGGER.debug("Configured kerberos system property [{}] to [{}]", (Object)SYS_PROP_KERB5_KDC, (Object)this.kerberosKdcSystemProperty);
            System.setProperty(SYS_PROP_KERB5_KDC, this.kerberosKdcSystemProperty);
        }
        if (this.kerberosRealmSystemProperty != null) {
            LOGGER.debug("Setting kerberos system property [{}] to [{}]", (Object)SYS_PROP_KRB5_REALM, (Object)this.kerberosRealmSystemProperty);
            System.setProperty(SYS_PROP_KRB5_REALM, this.kerberosRealmSystemProperty);
        }
        String username = credential.getUsername();
        String password = credential.getPassword();
        org.apereo.cas.authentication.principal.Principal principal = null;
        LoginContext lc = new LoginContext(this.realm, new UsernamePasswordCallbackHandler(username, password));
        try {
            LOGGER.debug("Attempting authentication for: [{}]", (Object)username);
            lc.login();
            Set<Principal> principals = lc.getSubject().getPrincipals();
            if (principals != null && !principals.isEmpty()) {
                Principal secPrincipal = principals.iterator().next();
                principal = this.principalFactory.createPrincipal(secPrincipal.getName());
            }
        }
        finally {
            lc.logout();
        }
        return this.createHandlerResult(credential, principal, null);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setKerberosRealmSystemProperty(String kerberosRealmSystemProperty) {
        this.kerberosRealmSystemProperty = kerberosRealmSystemProperty;
    }

    public void setKerberosKdcSystemProperty(String kerberosKdcSystemProperty) {
        this.kerberosKdcSystemProperty = kerberosKdcSystemProperty;
    }

    protected static class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        protected UsernamePasswordCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) {
            Arrays.stream(callbacks).filter(callback -> {
                if (callback.getClass().equals(NameCallback.class)) {
                    ((NameCallback)callback).setName(this.userName);
                    return false;
                }
                if (callback.getClass().equals(PasswordCallback.class)) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    return false;
                }
                return true;
            }).findFirst().ifPresent(callback -> {
                throw new IllegalArgumentException(new UnsupportedCallbackException((Callback)callback, "Unrecognized Callback"));
            });
        }
    }
}

