/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultHandlerResult;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.PrePostAuthenticationHandler;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;

public abstract class AbstractPreAndPostProcessingAuthenticationHandler
extends AbstractAuthenticationHandler
implements PrePostAuthenticationHandler {
    public AbstractPreAndPostProcessingAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        if (!this.preAuthenticate(credential)) {
            throw new FailedLoginException();
        }
        return this.postAuthenticate(credential, this.doAuthentication(credential));
    }

    protected abstract HandlerResult doAuthentication(Credential var1) throws GeneralSecurityException, PreventedException;

    protected HandlerResult createHandlerResult(Credential credential, Principal principal, List<MessageDescriptor> warnings) {
        return new DefaultHandlerResult(this, (CredentialMetaData)new BasicCredentialMetaData(credential), principal, warnings);
    }
}

