/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.handler.support.HttpBasedServiceCredentialsAuthenticationHandler;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceAuthenticationHandlerResolver
implements AuthenticationHandlerResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceAuthenticationHandlerResolver.class);
    protected final ServicesManager servicesManager;

    public RegisteredServiceAuthenticationHandlerResolver(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public Set<AuthenticationHandler> resolve(Set<AuthenticationHandler> candidateHandlers, AuthenticationTransaction transaction) {
        Service service = transaction.getService();
        if (service != null && this.servicesManager != null) {
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.warn("Service [{}] is not allowed to use SSO.", (Object)registeredService);
                throw new UnauthorizedSsoServiceException();
            }
            if (!registeredService.getRequiredHandlers().isEmpty()) {
                LOGGER.debug("Authentication transaction requires [{}] for service [{}]", (Object)registeredService.getRequiredHandlers(), (Object)service);
                LinkedHashSet<AuthenticationHandler> handlerSet = new LinkedHashSet<AuthenticationHandler>(candidateHandlers);
                LOGGER.info("Candidate authentication handlers examined this transaction are [{}]", handlerSet);
                Iterator it = handlerSet.iterator();
                while (it.hasNext()) {
                    AuthenticationHandler handler = (AuthenticationHandler)it.next();
                    if (handler instanceof HttpBasedServiceCredentialsAuthenticationHandler || registeredService.getRequiredHandlers().contains(handler.getName())) continue;
                    LOGGER.debug("Authentication handler [{}] is not required for this transaction and is removed", (Object)handler.getName());
                    it.remove();
                }
                LOGGER.debug("Authentication handlers for this transaction are [{}]", handlerSet);
                return handlerSet;
            }
            LOGGER.debug("No specific authentication handlers are required for this transaction");
        }
        String handlers = candidateHandlers.stream().map(AuthenticationHandler::getName).collect(Collectors.joining(","));
        LOGGER.debug("Authentication handlers used for this transaction are [{}]", (Object)handlers);
        return candidateHandlers;
    }
}

