/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationCredentialsLocalBinder;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationManager;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.RegisteredServiceAuthenticationHandlerResolver;
import org.apereo.cas.authentication.exceptions.UnresolvedPrincipalException;
import org.apereo.cas.authentication.policy.AnyAuthenticationPolicy;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.authentication.CasAuthenticationPolicyFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationPrincipalResolvedEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionStartedEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionSuccessfulEvent;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;

public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyBasedAuthenticationManager.class);
    protected final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;
    protected final AuthenticationHandlerResolver authenticationHandlerResolver;
    protected boolean principalResolutionFailureFatal;
    protected Collection<AuthenticationPolicy> authenticationPolicies;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    protected PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, AuthenticationHandlerResolver authenticationHandlerResolver, Collection<AuthenticationPolicy> authenticationPolicies) {
        this.authenticationPolicies = authenticationPolicies;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
        this.authenticationHandlerResolver = authenticationHandlerResolver;
    }

    public PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, AuthenticationHandlerResolver authenticationHandlerResolver, Collection<AuthenticationPolicy> authenticationPolicies, boolean principalResolutionFatal) {
        this(authenticationEventExecutionPlan, authenticationHandlerResolver, authenticationPolicies);
        this.principalResolutionFailureFatal = principalResolutionFatal;
    }

    public PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, ServicesManager servicesManager, Collection<AuthenticationPolicy> authenticationPolicy) {
        this(authenticationEventExecutionPlan, new RegisteredServiceAuthenticationHandlerResolver(servicesManager), authenticationPolicy);
    }

    public PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, ServicesManager servicesManager) {
        this(authenticationEventExecutionPlan, servicesManager, (Collection<AuthenticationPolicy>)CollectionUtils.wrap((Object)new AnyAuthenticationPolicy(false)));
    }

    public PolicyBasedAuthenticationManager(AuthenticationEventExecutionPlan authenticationEventExecutionPlan, ServicesManager servicesManager, AuthenticationPolicy policy) {
        this(authenticationEventExecutionPlan, servicesManager, (Collection<AuthenticationPolicy>)CollectionUtils.wrap((Object)policy));
    }

    protected void invokeAuthenticationPostProcessors(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        LOGGER.debug("Invoking authentication post processors for authentication transaction");
        Collection pops = this.authenticationEventExecutionPlan.getAuthenticationPostProcessors(transaction);
        Collection supported = pops.stream().filter(processor -> transaction.getCredentials().stream().filter(arg_0 -> ((AuthenticationPostProcessor)processor).supports(arg_0)).findFirst().isPresent()).collect(Collectors.toList());
        for (AuthenticationPostProcessor p : supported) {
            p.process(builder, transaction);
        }
    }

    protected void populateAuthenticationMetadataAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        LOGGER.debug("Invoking authentication metadata populators for authentication transaction");
        Collection<AuthenticationMetaDataPopulator> pops = this.getAuthenticationMetadataPopulatorsForTransaction(transaction);
        pops.forEach(populator -> transaction.getCredentials().stream().filter(arg_0 -> ((AuthenticationMetaDataPopulator)populator).supports(arg_0)).forEach(credential -> populator.populateAttributes(builder, transaction)));
    }

    protected void addAuthenticationMethodAttribute(AuthenticationBuilder builder, Authentication authentication) {
        authentication.getSuccesses().values().forEach(result -> builder.addAttribute("authenticationMethod", (Object)result.getHandlerName()));
    }

    protected Principal resolvePrincipal(AuthenticationHandler handler, PrincipalResolver resolver, Credential credential, Principal principal) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential, principal, handler);
                LOGGER.debug("[{}] resolved [{}] from [{}]", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                LOGGER.error("[{}] failed to resolve principal from [{}]", new Object[]{resolver, credential, e});
            }
        } else {
            LOGGER.warn("[{}] is configured to use [{}] but it does not support [{}], which suggests a configuration problem.", new Object[]{handler.getName(), resolver, credential});
        }
        return null;
    }

    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Timed(name="AUTHENTICATE_TIMER")
    @Metered(name="AUTHENTICATE_METER")
    @Counted(name="AUTHENTICATE_COUNT", monotonic=true)
    public Authentication authenticate(AuthenticationTransaction transaction) throws AuthenticationException {
        AuthenticationCredentialsLocalBinder.bindCurrent(transaction.getCredentials());
        AuthenticationBuilder builder = this.authenticateInternal(transaction);
        AuthenticationCredentialsLocalBinder.bindCurrent(builder);
        Authentication authentication = builder.build();
        this.addAuthenticationMethodAttribute(builder, authentication);
        this.populateAuthenticationMetadataAttributes(builder, transaction);
        this.invokeAuthenticationPostProcessors(builder, transaction);
        Authentication auth = builder.build();
        Principal principal = auth.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(auth);
        }
        LOGGER.info("Authenticated principal [{}] with attributes [{}] via credentials [{}].", new Object[]{principal.getId(), principal.getAttributes(), transaction.getCredentials()});
        AuthenticationCredentialsLocalBinder.bindCurrent(auth);
        return auth;
    }

    protected void authenticateAndResolvePrincipal(AuthenticationBuilder builder, Credential credential, PrincipalResolver resolver, AuthenticationHandler handler) throws GeneralSecurityException, PreventedException {
        this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionStartedEvent((Object)this, credential));
        HandlerResult result = handler.authenticate(credential);
        builder.addSuccess(handler.getName(), result);
        LOGGER.debug("Authentication handler [{}] successfully authenticated [{}]", (Object)handler.getName(), (Object)credential);
        this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionSuccessfulEvent((Object)this, credential));
        Principal principal = result.getPrincipal();
        if (resolver == null) {
            LOGGER.debug("No principal resolution is configured for [{}]. Falling back to handler principal [{}]", (Object)handler.getName(), (Object)principal);
        } else if ((principal = this.resolvePrincipal(handler, resolver, credential, principal)) == null) {
            if (this.principalResolutionFailureFatal) {
                LOGGER.warn("Principal resolution handled by [{}] produced a null principal for: [{}]CAS is configured to treat principal resolution failures as fatal.", (Object)resolver.getClass().getSimpleName(), (Object)credential);
                throw new UnresolvedPrincipalException();
            }
            LOGGER.warn("Principal resolution handled by [{}] produced a null principal. This is likely due to misconfiguration or missing attributes; CAS will attempt to use the principal produced by the authentication handler, if any.", (Object)resolver.getClass().getSimpleName());
        }
        if (principal != null) {
            builder.setPrincipal(principal);
        }
        LOGGER.debug("Final principal resolved for this authentication event is [{}]", (Object)principal);
        this.publishEvent((ApplicationEvent)new CasAuthenticationPrincipalResolvedEvent((Object)this, principal));
    }

    protected Set<AuthenticationHandler> getAuthenticationHandlersForThisTransaction(AuthenticationTransaction transaction) {
        Set handlers = this.authenticationEventExecutionPlan.getAuthenticationHandlersForTransaction(transaction);
        return this.authenticationHandlerResolver.resolve(handlers, transaction);
    }

    protected PrincipalResolver getPrincipalResolverLinkedToHandlerIfAny(AuthenticationHandler handler, AuthenticationTransaction transaction) {
        return this.authenticationEventExecutionPlan.getPrincipalResolverForAuthenticationTransaction(handler, transaction);
    }

    protected Collection<AuthenticationMetaDataPopulator> getAuthenticationMetadataPopulatorsForTransaction(AuthenticationTransaction transaction) {
        return this.authenticationEventExecutionPlan.getAuthenticationMetadataPopulators(transaction);
    }

    protected void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected AuthenticationBuilder authenticateInternal(AuthenticationTransaction transaction) throws AuthenticationException {
        boolean success;
        Collection credentials = transaction.getCredentials();
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(NullPrincipal.getInstance());
        credentials.stream().forEach(cred -> builder.addCredential(new BasicCredentialMetaData((Credential)cred)));
        Set<AuthenticationHandler> handlerSet = this.getAuthenticationHandlersForThisTransaction(transaction);
        Assert.notNull(handlerSet, (String)"Resolved authentication handlers for this transaction cannot be null");
        if (handlerSet.isEmpty()) {
            LOGGER.warn("Resolved authentication handlers for this transaction are empty");
        }
        if (!(success = credentials.stream().anyMatch(credential -> {
            boolean isSatisfied = handlerSet.stream().filter(handler -> handler.supports(credential)).anyMatch(handler -> {
                try {
                    PrincipalResolver resolver = this.getPrincipalResolverLinkedToHandlerIfAny((AuthenticationHandler)handler, transaction);
                    this.authenticateAndResolvePrincipal(builder, (Credential)credential, resolver, (AuthenticationHandler)handler);
                    Pair<Boolean, Set<Throwable>> failures = this.evaluateAuthenticationPolicies(builder.build());
                    return (Boolean)failures.getKey();
                }
                catch (Exception e) {
                    this.handleAuthenticationException(e, handler.getName(), builder);
                    return false;
                }
            });
            if (!isSatisfied) {
                LOGGER.error("Authentication has failed. Credentials may be incorrect or CAS cannot find authentication handler that supports [{}] of type [{}]. Examine the configuration to ensure a method of authentication is defined and analyze CAS logs at DEBUG level to trace the authentication event.", credential, (Object)credential.getClass().getSimpleName());
            }
            return isSatisfied;
        }))) {
            this.evaluateFinalAuthentication(builder, transaction);
        }
        return builder;
    }

    protected void evaluateFinalAuthentication(AuthenticationBuilder builder, AuthenticationTransaction transaction) throws AuthenticationException {
        if (builder.getSuccesses().isEmpty()) {
            this.publishEvent((ApplicationEvent)new CasAuthenticationTransactionFailureEvent((Object)this, builder.getFailures(), transaction.getCredentials()));
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        Authentication authentication = builder.build();
        Pair<Boolean, Set<Throwable>> failures = this.evaluateAuthenticationPolicies(authentication);
        if (!((Boolean)failures.getKey()).booleanValue()) {
            this.publishEvent((ApplicationEvent)new CasAuthenticationPolicyFailureEvent((Object)this, builder.getFailures(), transaction, authentication));
            ((Set)failures.getValue()).forEach(e -> this.handleAuthenticationException((Throwable)e, e.getClass().getSimpleName(), builder));
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
    }

    protected Pair<Boolean, Set<Throwable>> evaluateAuthenticationPolicies(Authentication authentication) {
        LinkedHashSet failures = new LinkedHashSet();
        ArrayList<AuthenticationPolicy> policies = new ArrayList<AuthenticationPolicy>(this.authenticationPolicies);
        OrderComparator.sort(policies);
        policies.stream().forEach(p -> {
            try {
                String simpleName = p.getClass().getSimpleName();
                LOGGER.debug("Executing authentication policy [{}]", (Object)simpleName);
                if (!p.isSatisfiedBy(authentication)) {
                    failures.add(new AuthenticationException("Unable to satisfy authentication policy " + simpleName));
                }
            }
            catch (GeneralSecurityException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                failures.add(e.getCause());
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                failures.add(e);
            }
        });
        return Pair.of((Object)failures.isEmpty(), failures);
    }

    protected void handleAuthenticationException(Throwable e, String name, AuthenticationBuilder builder) {
        String msg = e.getMessage();
        if (e.getCause() != null) {
            msg = msg + " / " + e.getCause().getMessage();
        }
        if (e instanceof GeneralSecurityException) {
            LOGGER.debug("[{}] exception details: [{}].", (Object)name, (Object)msg);
            builder.addFailure(name, e.getClass());
        } else {
            LOGGER.error("[{}]: [{}]", (Object)name, (Object)msg);
            builder.addFailure(name, e.getClass());
        }
    }
}

