/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrincipalElectionStrategy
implements PrincipalElectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPrincipalElectionStrategy.class);
    private static final long serialVersionUID = 6704726217030836315L;
    private final PrincipalFactory principalFactory;

    public DefaultPrincipalElectionStrategy() {
        this(new DefaultPrincipalFactory());
    }

    public DefaultPrincipalElectionStrategy(PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    public Principal nominate(Collection<Authentication> authentications, Map<String, Object> principalAttributes) {
        Principal principal = authentications.iterator().next().getPrincipal();
        Principal finalPrincipal = this.principalFactory.createPrincipal(principal.getId(), principalAttributes);
        LOGGER.debug("Nominated [{}] as the primary principal", (Object)finalPrincipal);
        return finalPrincipal;
    }
}

