/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.util.Assert;

public class DefaultHandlerResult
implements HandlerResult {
    private static final long serialVersionUID = -3113998493287982485L;
    private String handlerName;
    private CredentialMetaData credentialMetaData;
    private Principal principal;
    private List<MessageDescriptor> warnings;

    private DefaultHandlerResult() {
    }

    public DefaultHandlerResult(AuthenticationHandler source, CredentialMetaData metaData) {
        this(source, metaData, null, null);
    }

    public DefaultHandlerResult(AuthenticationHandler source, CredentialMetaData metaData, Principal p) {
        this(source, metaData, p, null);
    }

    public DefaultHandlerResult(AuthenticationHandler source, CredentialMetaData metaData, List<MessageDescriptor> warnings) {
        this(source, metaData, null, warnings);
    }

    public DefaultHandlerResult(AuthenticationHandler source, CredentialMetaData metaData, Principal p, List<MessageDescriptor> warnings) {
        this(StringUtils.isBlank((CharSequence)source.getName()) ? source.getClass().getSimpleName() : source.getName(), metaData, p, warnings);
    }

    public DefaultHandlerResult(String handlerName, CredentialMetaData metaData, Principal p, List<MessageDescriptor> warnings) {
        Assert.notNull((Object)metaData, (String)"Credential metadata cannot be null.");
        this.handlerName = handlerName;
        this.credentialMetaData = metaData;
        this.principal = p;
        this.warnings = warnings;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public CredentialMetaData getCredentialMetaData() {
        return this.credentialMetaData;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public List<MessageDescriptor> getWarnings() {
        return this.warnings == null ? new ArrayList<MessageDescriptor>(0) : new ArrayList<MessageDescriptor>(this.warnings);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(109, 31);
        builder.append((Object)this.handlerName);
        builder.append((Object)this.credentialMetaData);
        builder.append((Object)this.principal);
        builder.append(this.warnings);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultHandlerResult)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DefaultHandlerResult other = (DefaultHandlerResult)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.handlerName, (Object)other.handlerName);
        builder.append((Object)this.credentialMetaData, (Object)other.credentialMetaData);
        builder.append((Object)this.principal, (Object)other.principal);
        builder.append((Object)CollectionUtils.wrap(this.warnings), (Object)CollectionUtils.wrap(other.warnings));
        return builder.isEquals();
    }

    public String toString() {
        return this.handlerName + ':' + this.credentialMetaData;
    }
}

