/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;

public class DefaultAuthenticationSystemSupport
implements AuthenticationSystemSupport {
    private final AuthenticationTransactionManager authenticationTransactionManager;
    private final PrincipalElectionStrategy principalElectionStrategy;

    public DefaultAuthenticationSystemSupport(AuthenticationTransactionManager authenticationTransactionManager, PrincipalElectionStrategy principalElectionStrategy) {
        this.authenticationTransactionManager = authenticationTransactionManager;
        this.principalElectionStrategy = principalElectionStrategy;
    }

    public AuthenticationTransactionManager getAuthenticationTransactionManager() {
        return this.authenticationTransactionManager;
    }

    public PrincipalElectionStrategy getPrincipalElectionStrategy() {
        return this.principalElectionStrategy;
    }

    public AuthenticationResultBuilder handleInitialAuthenticationTransaction(Service service, Credential ... credential) throws AuthenticationException {
        DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder(this.principalElectionStrategy);
        if (credential != null && credential.length > 0) {
            builder.collect(credential[0]);
        }
        return this.handleAuthenticationTransaction(service, builder, credential);
    }

    public AuthenticationResultBuilder establishAuthenticationContextFromInitial(Authentication authentication, Credential credentials) {
        return new DefaultAuthenticationResultBuilder(this.principalElectionStrategy).collect(authentication).collect(credentials);
    }

    public AuthenticationResultBuilder handleAuthenticationTransaction(Service service, AuthenticationResultBuilder authenticationResultBuilder, Credential ... credential) throws AuthenticationException {
        AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Service)service, (Credential[])credential);
        this.authenticationTransactionManager.handle(transaction, authenticationResultBuilder);
        return authenticationResultBuilder;
    }

    public AuthenticationResult finalizeAllAuthenticationTransactions(AuthenticationResultBuilder authenticationResultBuilder, Service service) {
        return authenticationResultBuilder.build(service);
    }

    public AuthenticationResult handleAndFinalizeSingleAuthenticationTransaction(Service service, Credential ... credential) throws AuthenticationException {
        return this.finalizeAllAuthenticationTransactions(this.handleInitialAuthenticationTransaction(service, credential), service);
    }
}

