/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.springframework.core.OrderComparator;

public class DefaultAuthenticationServiceSelectionPlan
implements AuthenticationServiceSelectionPlan {
    private final List<AuthenticationServiceSelectionStrategy> strategies;

    public DefaultAuthenticationServiceSelectionPlan() {
        this.strategies = new ArrayList<AuthenticationServiceSelectionStrategy>();
    }

    public DefaultAuthenticationServiceSelectionPlan(AuthenticationServiceSelectionStrategy ... strategies) {
        this.strategies = Arrays.stream(strategies).collect(Collectors.toList());
        OrderComparator.sort(this.strategies);
    }

    public void registerStrategy(AuthenticationServiceSelectionStrategy strategy) {
        this.strategies.add(strategy);
        OrderComparator.sort(this.strategies);
    }

    public Service resolveService(Service service) {
        return this.strategies.stream().filter(s -> s.supports(service)).findFirst().get().resolveServiceFrom(service);
    }
}

