/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthentication;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.util.Assert;

public class DefaultAuthenticationBuilder
implements AuthenticationBuilder {
    private static final long serialVersionUID = -8504842011648432398L;
    private Principal principal;
    private final List<CredentialMetaData> credentials = new ArrayList<CredentialMetaData>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, HandlerResult> successes = new LinkedHashMap<String, HandlerResult>();
    private final Map<String, Class<? extends Throwable>> failures = new LinkedHashMap<String, Class<? extends Throwable>>();
    private ZonedDateTime authenticationDate = ZonedDateTime.now();

    public DefaultAuthenticationBuilder() {
    }

    public DefaultAuthenticationBuilder(Principal p) {
        this();
        this.principal = p;
    }

    public ZonedDateTime getAuthenticationDate() {
        return this.authenticationDate;
    }

    public AuthenticationBuilder setAuthenticationDate(ZonedDateTime d) {
        this.authenticationDate = d;
        return this;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public AuthenticationBuilder addCredentials(List<CredentialMetaData> credentials) {
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder setPrincipal(Principal p) {
        this.principal = p;
        return this;
    }

    public List<CredentialMetaData> getCredentials() {
        return this.credentials;
    }

    public AuthenticationBuilder setCredentials(List<CredentialMetaData> credentials) {
        Assert.notNull(credentials, (String)"Credential cannot be null");
        this.credentials.clear();
        this.credentials.addAll(credentials);
        return this;
    }

    public AuthenticationBuilder addCredential(CredentialMetaData credential) {
        this.credentials.add(credential);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public AuthenticationBuilder setAttributes(Map<String, Object> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
        return this;
    }

    public AuthenticationBuilder mergeAttribute(String key, Object value) {
        Object currentValue = this.attributes.get(key);
        if (currentValue == null) {
            return this.addAttribute(key, value);
        }
        Set collection = CollectionUtils.toCollection((Object)currentValue);
        collection.addAll(CollectionUtils.toCollection((Object)value));
        return this.addAttribute(key, collection);
    }

    public boolean hasAttribute(String name, Predicate<Object> predicate) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.get(name);
            Set valueCol = CollectionUtils.toCollection((Object)value);
            return valueCol.stream().filter(predicate).count() > 0L;
        }
        return false;
    }

    public AuthenticationBuilder addAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Map<String, HandlerResult> getSuccesses() {
        return this.successes;
    }

    public AuthenticationBuilder setSuccesses(Map<String, HandlerResult> successes) {
        Assert.notNull(successes, (String)"Successes cannot be null");
        this.successes.clear();
        return this.addSuccesses(successes);
    }

    public AuthenticationBuilder addSuccesses(Map<String, HandlerResult> successes) {
        successes.entrySet().stream().forEach(entry -> this.addSuccess((String)entry.getKey(), (HandlerResult)entry.getValue()));
        return this;
    }

    public AuthenticationBuilder addSuccess(String key, HandlerResult value) {
        this.successes.put(key, value);
        return this;
    }

    public Map<String, Class<? extends Throwable>> getFailures() {
        return this.failures;
    }

    public AuthenticationBuilder setFailures(Map<String, Class<? extends Throwable>> failures) {
        Assert.notNull(failures, (String)"Failures cannot be null");
        this.failures.clear();
        return this.addFailures(failures);
    }

    public AuthenticationBuilder addFailures(Map<String, Class<? extends Throwable>> failures) {
        failures.entrySet().stream().forEach(entry -> this.addFailure((String)entry.getKey(), (Class)entry.getValue()));
        return this;
    }

    public AuthenticationBuilder addFailure(String key, Class<? extends Throwable> value) {
        this.failures.put(key, value);
        return this;
    }

    public Authentication build() {
        return new DefaultAuthentication(this.authenticationDate, this.credentials, this.principal, this.attributes, this.successes, this.failures);
    }

    public static AuthenticationBuilder newInstance(Authentication source) {
        DefaultAuthenticationBuilder builder = new DefaultAuthenticationBuilder(source.getPrincipal());
        builder.setAuthenticationDate(source.getAuthenticationDate());
        builder.setCredentials(source.getCredentials());
        builder.setSuccesses(source.getSuccesses());
        builder.setFailures(source.getFailures());
        builder.setAttributes(source.getAttributes());
        return builder;
    }

    public static AuthenticationBuilder newInstance() {
        return new DefaultAuthenticationBuilder();
    }
}

