/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;
import org.springframework.util.Assert;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public class DefaultAuthentication
implements Authentication {
    private static final long serialVersionUID = 3206127526058061391L;
    private ZonedDateTime authenticationDate;
    private List<CredentialMetaData> credentials;
    private final Principal principal;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Map<String, HandlerResult> successes;
    private Map<String, Class<? extends Throwable>> failures;

    private DefaultAuthentication() {
        this.authenticationDate = null;
        this.credentials = null;
        this.principal = null;
        this.attributes = null;
        this.successes = null;
        this.failures = null;
    }

    public DefaultAuthentication(ZonedDateTime date, Principal principal, Map<String, Object> attributes, Map<String, HandlerResult> successes) {
        Assert.notNull((Object)date, (String)"Date cannot be null");
        Assert.notNull((Object)principal, (String)"Principal cannot be null");
        Assert.notNull(successes, (String)"Successes cannot be null");
        Assert.notEmpty(successes, (String)"Successes cannot be empty");
        this.authenticationDate = date;
        this.principal = principal;
        this.attributes = attributes;
        this.successes = successes;
        this.credentials = null;
        this.failures = null;
    }

    public DefaultAuthentication(ZonedDateTime date, List<CredentialMetaData> credentials, Principal principal, Map<String, Object> attributes, Map<String, HandlerResult> successes, Map<String, Class<? extends Throwable>> failures) {
        this(date, principal, attributes, successes);
        Assert.notNull(credentials, (String)"Credential cannot be null");
        Assert.notEmpty(credentials, (String)"Credential cannot be empty");
        this.credentials = credentials;
        this.failures = failures.isEmpty() ? new HashMap(0) : failures;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public ZonedDateTime getAuthenticationDate() {
        return this.authenticationDate;
    }

    public Map<String, Object> getAttributes() {
        return CollectionUtils.wrap(this.attributes);
    }

    public List<CredentialMetaData> getCredentials() {
        return CollectionUtils.wrap(this.credentials);
    }

    public Map<String, HandlerResult> getSuccesses() {
        return new HashMap<String, HandlerResult>(this.successes);
    }

    public Map<String, Class<? extends Throwable>> getFailures() {
        return CollectionUtils.wrap(this.failures);
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(97, 31);
        builder.append((Object)this.principal);
        builder.append((Object)this.authenticationDate);
        builder.append(this.attributes);
        builder.append(this.credentials);
        builder.append(this.successes);
        builder.append(this.failures);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Authentication)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Authentication other = (Authentication)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.principal, (Object)other.getPrincipal());
        builder.append(this.credentials, (Object)other.getCredentials());
        builder.append(this.successes, (Object)other.getSuccesses());
        builder.append((Object)this.authenticationDate, (Object)other.getAuthenticationDate());
        builder.append((Object)CollectionUtils.wrap(this.attributes), (Object)other.getAttributes());
        builder.append((Object)CollectionUtils.wrap(this.failures), (Object)other.getFailures());
        return builder.isEquals();
    }

    public void update(Authentication authn) {
        this.attributes.putAll(authn.getAttributes());
        this.authenticationDate = authn.getAuthenticationDate();
    }

    public void updateAll(Authentication authn) {
        this.attributes.clear();
        this.update(authn);
    }

    public void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }
}

