/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import groovy.lang.GroovyClassLoader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.util.CollectionUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public final class CoreAuthenticationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreAuthenticationUtils.class);

    private CoreAuthenticationUtils() {
    }

    public static Map<String, Collection<String>> transformPrincipalAttributesListIntoMap(List<String> list) {
        Multimap<String, String> map = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap(list);
        return CollectionUtils.wrap(map);
    }

    public static Multimap<String, String> transformPrincipalAttributesListIntoMultiMap(List<String> list) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (list.isEmpty()) {
            LOGGER.debug("No principal attributes are defined");
        } else {
            list.forEach(arg_0 -> CoreAuthenticationUtils.lambda$transformPrincipalAttributesListIntoMultiMap$0((Multimap)multimap, arg_0));
        }
        return multimap;
    }

    public static Predicate<Credential> newCredentialSelectionPredicate(String selectionCriteria) {
        try {
            DefaultResourceLoader loader;
            Resource resource;
            if (StringUtils.isBlank((CharSequence)selectionCriteria)) {
                return credential -> true;
            }
            if (selectionCriteria.endsWith(".groovy") && (resource = (loader = new DefaultResourceLoader()).getResource(selectionCriteria)) != null) {
                String script = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                GroovyClassLoader classLoader = new GroovyClassLoader(Beans.class.getClassLoader(), new CompilerConfiguration(), true);
                Class clz = classLoader.parseClass(script);
                return (Predicate)clz.newInstance();
            }
            Class predicateClazz = ClassUtils.getClass((String)selectionCriteria);
            return (Predicate)predicateClazz.newInstance();
        }
        catch (Exception e) {
            Predicate<String> predicate = Pattern.compile(selectionCriteria).asPredicate();
            return credential -> predicate.test(credential.getId());
        }
    }

    private static /* synthetic */ void lambda$transformPrincipalAttributesListIntoMultiMap$0(Multimap multimap, String a) {
        String attributeName = a.trim();
        if (attributeName.contains(":")) {
            String[] attrCombo = attributeName.split(":");
            String name = attrCombo[0].trim();
            String value = attrCombo[1].trim();
            LOGGER.debug("Mapped principal attribute name [{}] to [{}]", (Object)name, (Object)value);
            multimap.put((Object)name, (Object)value);
        } else {
            LOGGER.debug("Mapped principal attribute name [{}]", (Object)attributeName);
            multimap.put((Object)attributeName, (Object)attributeName);
        }
    }
}

