/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.codec.binary.StringUtils;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptUsersAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptUsersAuthenticationHandler.class);
    private Map<String, String> users;

    public AcceptUsersAuthenticationHandler(String name) {
        this(name, null, null, null, new HashMap<String, String>());
    }

    public AcceptUsersAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, Map<String, String> users) {
        super(name, servicesManager, principalFactory, order);
        this.users = users;
    }

    @Override
    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) throws GeneralSecurityException {
        if (this.users == null || this.users.isEmpty()) {
            throw new FailedLoginException("No user can be accepted because none is defined");
        }
        String username = credential.getUsername();
        String cachedPassword = this.users.get(username);
        if (cachedPassword == null) {
            LOGGER.debug("[{}] was not found in the map.", (Object)username);
            throw new AccountNotFoundException(username + " not found in backing map.");
        }
        if (!StringUtils.equals((CharSequence)credential.getPassword(), (CharSequence)cachedPassword)) {
            throw new FailedLoginException();
        }
        ArrayList<MessageDescriptor> list = new ArrayList<MessageDescriptor>();
        return this.createHandlerResult(credential, this.principalFactory.createPrincipal(username), list);
    }

    public void setUsers(Map<String, String> users) {
        this.users = new HashMap<String, String>(users);
    }
}

