/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.function.Predicate;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    protected final PrincipalFactory principalFactory;
    protected final ServicesManager servicesManager;
    protected Predicate<Credential> credentialSelectionPredicate = credential -> true;
    private final String name;
    private final int order;

    public AbstractAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        this.name = StringUtils.isNotBlank((CharSequence)name) ? name : this.getClass().getSimpleName();
        this.servicesManager = servicesManager;
        this.principalFactory = principalFactory == null ? new DefaultPrincipalFactory() : principalFactory;
        this.order = order == null ? RandomUtils.nextInt((int)1, (int)Integer.MAX_VALUE) : order;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCredentialSelectionPredicate(Predicate<Credential> credentialSelectionPredicate) {
        this.credentialSelectionPredicate = credentialSelectionPredicate;
    }
}

