/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apereo.cas.audit.spi.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.util.AopUtils;
import org.apereo.cas.validation.Assertion;
import org.aspectj.lang.JoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketValidationResourceResolver
extends TicketAsFirstParameterResourceResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketValidationResourceResolver.class);
    private final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();

    @Override
    public String[] resolveFrom(JoinPoint joinPoint, Object object) {
        ArrayList<String> auditResourceResults = new ArrayList<String>();
        Object[] args = AopUtils.unWrapJoinPoint((JoinPoint)joinPoint).getArgs();
        if (args != null && args.length > 0) {
            String ticketId = args[0].toString();
            auditResourceResults.add(ticketId);
        }
        if (object instanceof Assertion) {
            Assertion assertion = (Assertion)Assertion.class.cast(object);
            Authentication authn = assertion.getPrimaryAuthentication();
            try (StringWriter writer = new StringWriter();){
                ObjectWriter objectWriter = this.mapper.writer();
                LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
                results.put("principal", authn.getPrincipal().getId());
                LinkedHashMap attributes = new LinkedHashMap(authn.getAttributes());
                attributes.putAll(authn.getPrincipal().getAttributes());
                results.put("attributes", attributes);
                objectWriter.writeValue((Writer)writer, results);
                auditResourceResults.add(writer.toString());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return auditResourceResults.toArray(new String[0]);
    }
}

