/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.services.RegisteredService;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public interface RegisteredServiceProperty
extends Serializable {
    public Set<String> getValues();

    public String getValue();

    public boolean contains(String var1);

    @JsonFormat(shape=JsonFormat.Shape.OBJECT)
    public static enum RegisteredServiceProperties {
        WSFED_RELYING_PARTY_ID("wsfed.relyingPartyIdentifier", ""),
        TOKEN_AS_RESPONSE("jwtAsResponse", "true"),
        TOKEN_AS_SERVICE_TICKET("jwtAsServiceTicket", "false"),
        TOKEN_SECRET_SIGNING("jwtSigningSecret", ""),
        TOKEN_SECRET_SIGNING_ALG("jwtSigningSecretAlg", "HS256"),
        TOKEN_SECRET_ENCRYPTION("jwtEncryptionSecret", ""),
        TOKEN_SECRET_ENCRYPTION_ALG("jwtEncryptionSecretAlg", ""),
        TOKEN_SECRET_ENCRYPTION_METHOD("jwtEncryptionSecretMethod", "A192CBC-HS384"),
        TOKEN_SECRETS_ARE_BASE64_ENCODED("jwtSecretsAreBase64Encoded", "false");

        private final String propertyName;
        private final String defaultValue;

        private RegisteredServiceProperties(String name, String defaultValue) {
            this.propertyName = name;
            this.defaultValue = defaultValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public RegisteredServiceProperty getPropertyValue(RegisteredService service) {
            Optional<Map.Entry> property;
            if (this.isAssignedTo(service) && (property = service.getProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(this.getPropertyName()) && StringUtils.isNotBlank((CharSequence)((RegisteredServiceProperty)entry.getValue()).getValue())).distinct().findFirst()).isPresent()) {
                return (RegisteredServiceProperty)property.get().getValue();
            }
            return null;
        }

        public <T> T getPropertyValue(RegisteredService service, Class<T> clazz) {
            RegisteredServiceProperty prop;
            if (this.isAssignedTo(service) && (prop = this.getPropertyValue(service)) != null) {
                return clazz.cast(prop.getValue());
            }
            return null;
        }

        public boolean isAssignedTo(RegisteredService service) {
            return service.getProperties().entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equalsIgnoreCase(this.getPropertyName()) && StringUtils.isNotBlank((CharSequence)((RegisteredServiceProperty)entry.getValue()).getValue()));
        }
    }
}

