/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.config;

import java.io.File;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apereo.cas.support.events.AbstractCasEvent;

public class CasConfigurationModifiedEvent
extends AbstractCasEvent {
    private static final long serialVersionUID = -5738763037210896455L;
    private static final Pattern CONFIG_FILE_PATTERN = Pattern.compile("\\.(properties|yml)", 2);
    private final transient Path file;
    private final boolean override;

    public CasConfigurationModifiedEvent(Object source, Path file) {
        this(source, file, false);
    }

    public CasConfigurationModifiedEvent(Object source, boolean override) {
        this(source, null, override);
    }

    public CasConfigurationModifiedEvent(Object source, Path file, boolean override) {
        super(source);
        this.file = file;
        this.override = override;
    }

    private Path getFile() {
        return this.file;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isEligibleForContextRefresh() {
        if (this.override) {
            return true;
        }
        if (this.getFile() != null) {
            File file = this.getFile().toFile();
            return CONFIG_FILE_PATTERN.matcher(file.getName()).find();
        }
        return false;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).appendSuper(super.toString()).append("file", (Object)this.file).append("override", this.override).toString();
    }
}

